/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRef;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRefTranlocal;

public class AlphaProgrammaticLongRef_atomicSetTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenSuccess() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 10L);
        long version = this.stm.getVersion();
        long found = ref.atomicSet(20L);
        Assert.assertEquals((long)10L, (long)found);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)20L, (long)ref.atomicGet());
        Assert.assertNull((Object)ref.___getLockOwner());
        AlphaProgrammaticLongRefTranlocal committed = (AlphaProgrammaticLongRefTranlocal)ref.___load();
        Assert.assertNotNull((Object)committed);
        Assert.assertTrue((boolean)committed.isCommitted());
        Assert.assertEquals((long)(version + 1L), (long)committed.getWriteVersion());
        Assert.assertEquals((long)20L, (long)committed.value);
    }

    @Test
    public void whenNoChange() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 10L);
        AlphaProgrammaticLongRefTranlocal committed = (AlphaProgrammaticLongRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        long found = ref.atomicSet(10L);
        Assert.assertEquals((long)10L, (long)found);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)ref.atomicGet());
        Assert.assertNull((Object)ref.___getLockOwner());
        Assert.assertSame((Object)committed, (Object)ref.___load());
    }

    @Test
    public void whenListenersExistsTheyAreNotified() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 10L);
        CheapLatch latch = new CheapLatch();
        ref.___registerRetryListener((Latch)latch, this.stm.getVersion() + 1L);
        ref.atomicSet(20L);
        Assert.assertNull((Object)ref.___getListeners());
        Assert.assertTrue((boolean)latch.isOpen());
    }

    @Test
    public void whenNotCommittedBefore() {
        AlphaProgrammaticLongRef ref = AlphaProgrammaticLongRef.createUncommitted((AlphaStm)this.stm);
        long version = this.stm.getVersion();
        try {
            ref.atomicSet(10L);
            Assert.fail();
        }
        catch (UncommittedReadConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.___load());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenTransactionAvailable_thenItsIgnored() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 10L);
        Transaction tx = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadTrackingEnabled(true).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        long version = this.stm.getVersion();
        long found = ref.atomicSet(20L);
        Assert.assertEquals((long)10L, (long)found);
        Assert.assertEquals((long)20L, (long)ref.atomicGet());
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)(version + 1L), (long)ref.___load().getWriteVersion());
    }
}

