/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.StmUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.programmatic.ProgrammaticLongRef;
import org.multiverse.api.programmatic.ProgrammaticRef;
import org.multiverse.api.programmatic.ProgrammaticRefFactory;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.templates.TransactionTemplate;

public class AlphaProgrammaticLongRef_blockingStressTest {
    private AlphaStm stm;
    private ProgrammaticLongRef ref;
    private ProgrammaticRef<Boolean> completedRef;
    private int consumerCount = 10;
    private int unprocessedCapacity = 1000;
    private volatile boolean stop;
    private ProgrammaticRefFactory refFactory;

    @Before
    public void setUp() {
        this.stop = false;
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        this.refFactory = this.stm.getProgrammaticRefFactoryBuilder().build();
        this.ref = this.refFactory.atomicCreateLongRef(0L);
        this.completedRef = this.refFactory.createRef((Object)false);
    }

    @Test
    public void test() {
        TestThread[] producers = new ProducerThread[this.consumerCount];
        for (int k = 0; k < producers.length; ++k) {
            producers[k] = new ProducerThread(k);
        }
        TestThread[] consumers = new ConsumerThread[this.consumerCount];
        for (int k = 0; k < producers.length; ++k) {
            consumers[k] = new ConsumerThread(k);
        }
        TestUtils.startAll((TestThread[])producers);
        TestUtils.startAll((TestThread[])consumers);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])producers);
        TestUtils.joinAll((TestThread[])consumers);
        long produceCount = this.sum((ProducerThread[])producers);
        long consumeCount = this.sum((ConsumerThread[])consumers);
        long leftOver = this.ref.get();
        Assert.assertEquals((long)produceCount, (long)(consumeCount + leftOver));
    }

    long sum(ProducerThread[] threads) {
        long result = 0L;
        for (ProducerThread thread : threads) {
            result += thread.count;
        }
        return result;
    }

    long sum(ConsumerThread[] threads) {
        long result = 0L;
        for (ConsumerThread thread : threads) {
            result += thread.count;
        }
        return result;
    }

    class ConsumerThread
    extends TestThread {
        long count;

        public ConsumerThread(int id) {
            super("ConsumerThread-" + id);
            this.count = 0L;
        }

        public void doRun() throws Exception {
            boolean again;
            do {
                again = this.consume();
                if (this.count % 100000L == 0L) {
                    System.out.printf("%s is at %s\n", this.getName(), this.count);
                }
                if (!again) continue;
                ++this.count;
            } while (again);
        }

        @TransactionalMethod(readonly=false)
        private boolean consume() {
            if (((Boolean)AlphaProgrammaticLongRef_blockingStressTest.this.completedRef.get()).booleanValue()) {
                return false;
            }
            long value = AlphaProgrammaticLongRef_blockingStressTest.this.ref.get();
            if (value == 0L) {
                StmUtils.retry();
            }
            AlphaProgrammaticLongRef_blockingStressTest.this.ref.inc(-1L);
            return true;
        }
    }

    class ProducerThread
    extends TestThread {
        long count;

        public ProducerThread(int id) {
            super("ProducerThread-" + id);
            this.count = 0L;
        }

        public void doRun() throws Exception {
            while (!AlphaProgrammaticLongRef_blockingStressTest.this.stop) {
                if (this.produce()) {
                    ++this.count;
                }
                if (this.count % 100000L != 0L) continue;
                System.out.printf("%s is at %s\n", this.getName(), this.count);
            }
            new TransactionTemplate(){

                public Object execute(Transaction tx) throws Exception {
                    AlphaProgrammaticLongRef_blockingStressTest.this.completedRef.set((Object)true);
                    return null;
                }
            }.execute();
        }

        @TransactionalMethod(readonly=false)
        private boolean produce() {
            if (((Boolean)AlphaProgrammaticLongRef_blockingStressTest.this.completedRef.get()).booleanValue()) {
                return false;
            }
            long value = AlphaProgrammaticLongRef_blockingStressTest.this.ref.get();
            if (value >= (long)AlphaProgrammaticLongRef_blockingStressTest.this.unprocessedCapacity) {
                StmUtils.retry();
            }
            AlphaProgrammaticLongRef_blockingStressTest.this.ref.inc(1L);
            return true;
        }
    }
}

