/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRef;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRefTranlocal;

public class AlphaProgrammaticLongRef_commutingIncTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenNoTransactionIsRunning_andNoChange() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 10L);
        AlphaProgrammaticLongRefTranlocal readonly = (AlphaProgrammaticLongRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        ref.commutingInc(0L);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)readonly, (Object)ref.___load());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenNoTransactionIsRunning_thenItIsExecutedAtomically() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 10L);
        long version = this.stm.getVersion();
        ref.commutingInc(3L);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        AlphaProgrammaticLongRefTranlocal readonly = (AlphaProgrammaticLongRefTranlocal)ref.___load();
        Assert.assertNotNull((Object)readonly);
        Assert.assertEquals((long)(version + 1L), (long)readonly.getWriteVersion());
        Assert.assertEquals((long)13L, (long)ref.atomicGet());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenNoTransactionIsRunningAndNoCommits() {
        AlphaProgrammaticLongRef ref = AlphaProgrammaticLongRef.createUncommitted((AlphaStm)this.stm);
        long version = this.stm.getVersion();
        try {
            ref.commutingInc(1L);
            Assert.fail();
        }
        catch (UncommittedReadConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.___load());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenTransactionRunning() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 1L);
        Transaction tx = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        long version = this.stm.getVersion();
        ref.commutingInc(10L);
        tx.commit();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)11L, (long)ref.atomicGet());
    }
}

