/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRef;

public class AlphaProgrammaticLongRef_commutingIncWithTransactionTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenTransactionNull_thenNullPointerException() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 1L);
        long version = this.stm.getVersion();
        try {
            ref.commutingInc(null, 20L);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)ref.atomicGet());
    }

    @Test
    public void commuting() {
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build();
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 10L);
        Transaction tx1 = txFactory.start();
        Transaction tx2 = txFactory.start();
        ref.commutingInc(tx1, 2L);
        ref.commutingInc(tx2, 3L);
        long version = this.stm.getVersion();
        tx1.commit();
        tx2.commit();
        Assert.assertEquals((long)15L, (long)ref.atomicGet());
        Assert.assertEquals((long)(version + 2L), (long)this.stm.getVersion());
    }

    @Test
    public void multipleCommutingIncs() {
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build();
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 10L);
        Transaction tx1 = txFactory.start();
        Transaction tx2 = txFactory.start();
        ref.commutingInc(tx1, 1L);
        ref.commutingInc(tx2, 1L);
        ref.commutingInc(tx1, 1L);
        tx1.commit();
        ref.commutingInc(tx2, 1L);
        long version = this.stm.getVersion();
        tx2.commit();
        Assert.assertEquals((long)14L, (long)ref.atomicGet());
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
    }
}

