/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticRef;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticRefFactory;
import org.multiverse.templates.TransactionTemplate;

public class AlphaProgrammaticRef_atomicGetTest {
    private AlphaProgrammaticRefFactory refFactory;
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = AlphaStm.createFast();
        this.refFactory = (AlphaProgrammaticRefFactory)this.stm.getProgrammaticRefFactoryBuilder().build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenNoTransactionRunningAndNullValue() {
        AlphaProgrammaticRef ref = this.refFactory.atomicCreateRef();
        long version = this.stm.getVersion();
        Assert.assertNull((Object)ref.atomicGet());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenNoTransactionRunningAndNonNullValue() {
        String value = "foo";
        AlphaProgrammaticRef ref = this.refFactory.atomicCreateRef((Object)value);
        long version = this.stm.getVersion();
        Assert.assertEquals((Object)value, (Object)ref.atomicGet());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    @Ignore
    public void whenTransactionUpAndRunningThenIgnored() {
        String oldValue = "oldvalue";
        final AlphaProgrammaticRef ref = this.refFactory.atomicCreateRef((Object)"oldvalue");
        long version = this.stm.getVersion();
        try {
            new TransactionTemplate(this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build()){

                public Object execute(Transaction tx) throws Exception {
                    System.out.println("1");
                    ref.set((Object)"newvalue");
                    System.out.println("2");
                    Assert.assertSame((Object)"oldvalue", (Object)ref.atomicGet());
                    System.out.println("3");
                    tx.abort();
                    return null;
                }
            }.execute();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

