/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.programmatic.ProgrammaticRefFactory;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticRef;
import org.multiverse.templates.TransactionTemplate;

public class AlphaProgrammaticRef_blockingStressTest {
    private AlphaStm stm;
    private ProgrammaticRefFactory refFactory;
    private AlphaProgrammaticRef<String> ref;
    private int consumerCount = 10;
    private volatile boolean stop;
    private String poison = "poison";

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stop = false;
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        this.refFactory = this.stm.getProgrammaticRefFactoryBuilder().build();
        this.ref = (AlphaProgrammaticRef)this.refFactory.atomicCreateRef(null);
    }

    @Test
    public void test() {
        TestThread[] producers = new ProducerThread[this.consumerCount];
        for (int k = 0; k < producers.length; ++k) {
            producers[k] = new ProducerThread(k);
        }
        TestThread[] consumers = new ConsumerThread[this.consumerCount];
        for (int k = 0; k < producers.length; ++k) {
            consumers[k] = new ConsumerThread(k);
        }
        TestUtils.startAll((TestThread[])producers);
        TestUtils.startAll((TestThread[])consumers);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])producers);
        TestUtils.joinAll((TestThread[])consumers);
        long producedCount = this.sum((ProducerThread[])producers);
        long consumedCount = this.sum((ConsumerThread[])consumers);
        Assert.assertEquals((long)producedCount, (long)consumedCount);
    }

    long sum(ProducerThread[] threads) {
        long result = 0L;
        for (ProducerThread thread : threads) {
            result += thread.count;
        }
        return result;
    }

    long sum(ConsumerThread[] threads) {
        long result = 0L;
        for (ConsumerThread thread : threads) {
            result += thread.count;
        }
        return result;
    }

    class ConsumerThread
    extends TestThread {
        long count;

        public ConsumerThread(int id) {
            super("ConsumerThread-" + id);
            this.count = 0L;
        }

        public void doRun() throws Exception {
            boolean again;
            do {
                again = this.consume();
                if (this.count % 10000L == 0L) {
                    System.out.printf("%s is at %s\n", this.getName(), this.count);
                }
                if (!again) continue;
                ++this.count;
            } while (again);
        }

        @TransactionalMethod(readonly=false)
        private boolean consume() {
            String value = (String)AlphaProgrammaticRef_blockingStressTest.this.ref.get();
            if (AlphaProgrammaticRef_blockingStressTest.this.poison.equals(value)) {
                return false;
            }
            if (value == null) {
                StmUtils.retry();
            }
            AlphaProgrammaticRef_blockingStressTest.this.ref.set(null);
            return true;
        }
    }

    class ProducerThread
    extends TestThread {
        long count;

        public ProducerThread(int id) {
            super("ProducerThread-" + id);
            this.count = 0L;
        }

        public void doRun() throws Exception {
            while (!AlphaProgrammaticRef_blockingStressTest.this.stop) {
                if (this.produce()) {
                    ++this.count;
                }
                if (this.count % 10000L != 0L) continue;
                System.out.printf("%s is at %s\n", this.getName(), this.count);
            }
            new TransactionTemplate(){

                public Object execute(Transaction tx) throws Exception {
                    if (AlphaProgrammaticRef_blockingStressTest.this.poison.equals(AlphaProgrammaticRef_blockingStressTest.this.ref.get())) {
                        return null;
                    }
                    if (AlphaProgrammaticRef_blockingStressTest.this.ref.get() != null) {
                        StmUtils.retry();
                    }
                    AlphaProgrammaticRef_blockingStressTest.this.ref.set((Object)AlphaProgrammaticRef_blockingStressTest.this.poison);
                    return null;
                }
            }.execute();
        }

        @TransactionalMethod(readonly=false)
        private boolean produce() {
            String value = (String)AlphaProgrammaticRef_blockingStressTest.this.ref.get();
            if (AlphaProgrammaticRef_blockingStressTest.this.poison.equals(value)) {
                return false;
            }
            if (value != null) {
                StmUtils.retry();
            }
            AlphaProgrammaticRef_blockingStressTest.this.ref.set((Object)"token");
            return true;
        }
    }
}

