/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions;

import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.multiverse.api.Listeners;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;

public class AlphaTransactionTestUtils {
    public static void assertHasNoListeners(ManualRef ref) {
        Assert.assertNull((Object)ref.___getListeners());
    }

    public static void assertHasListeners(ManualRef ref, Latch ... expectedLatches) {
        LinkedList<Latch> found = new LinkedList<Latch>();
        for (Listeners listener = ref.___getListeners(); listener != null; listener = listener.getNext()) {
            found.add(listener.getListener());
        }
        Assert.assertEquals(Arrays.asList(expectedLatches), found);
    }

    public static void assertIsUpdatableClone(ManualRef ref, AlphaTranlocal committed, AlphaTranlocal found) {
        Assert.assertNotNull((Object)found);
        Assert.assertSame((Object)committed, (Object)found.getOrigin());
        Assert.assertSame((Object)((Object)ref), (Object)found.getTransactionalObject());
        Assert.assertFalse((boolean)found.isCommitted());
    }

    public static void assertFreshTranlocal(ManualRef ref, AlphaTranlocal found) {
        Assert.assertNotNull((Object)found);
        Assert.assertSame((Object)((Object)ref), (Object)found.getTransactionalObject());
        Assert.assertNull((Object)found.getOrigin());
        Assert.assertFalse((boolean)found.isCommitted());
    }
}

