/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.readonly.ArrayReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class ArrayReadonlyAlphaTransaction_abortTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stm = new AlphaStm(this.stmConfig);
    }

    public ArrayReadonlyAlphaTransaction createTransactionUnderTest() {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true);
        return new ArrayReadonlyAlphaTransaction(config, 1);
    }

    @Test
    public void whenUsed() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        long expectedVersion = this.stm.getVersion();
        ArrayReadonlyAlphaTransaction tx = this.createTransactionUnderTest();
        tx.openForRead((AlphaTransactionalObject)ref);
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)((Object)expectedTranlocal), (Object)ref.___load());
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
    }

    @Test
    public void whenUnused() {
        long expectedVersion = this.stm.getVersion();
        ArrayReadonlyAlphaTransaction tx = this.createTransactionUnderTest();
        tx.abort();
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }
}

