/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.readonly.ArrayReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class ArrayReadonlyAlphaTransaction_resetTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stm = new AlphaStm(this.stmConfig);
    }

    public ArrayReadonlyAlphaTransaction createSutTransaction() {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true);
        return new ArrayReadonlyAlphaTransaction(config, 100);
    }

    @Test
    public void whenUnused() {
        ArrayReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.reset();
        Assert.assertEquals((Object)0, (Object)TestUtils.getField((Object)tx, (String)"firstFreeIndex"));
        TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenOtherTxCommitted_thenReadVersionUpdated() {
        ArrayReadonlyAlphaTransaction tx = this.createSutTransaction();
        this.stmConfig.clock.tick();
        tx.reset();
        TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }

    @Test
    public void whenUsed() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        ManualRef ref3 = new ManualRef(this.stm);
        ArrayReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref1);
        tx.openForRead((AlphaTransactionalObject)ref2);
        tx.openForRead((AlphaTransactionalObject)ref3);
        tx.reset();
        Assert.assertEquals((Object)0, (Object)TestUtils.getField((Object)tx, (String)"firstFreeIndex"));
        AlphaTranlocal[] attached = (AlphaTranlocal[])TestUtils.getField((Object)tx, (String)"attachedArray");
        for (int k = 0; k < attached.length; ++k) {
            Assert.assertNull((Object)attached[k]);
        }
    }
}

