/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.readonly.MapReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class MapReadonlyAlphaTransaction_openForCommutingWriteTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MapReadonlyAlphaTransaction createSutTransaction() {
        return this.createSutTransaction(new SpeculativeConfiguration(100));
    }

    public MapReadonlyAlphaTransaction createSutTransaction(SpeculativeConfiguration speculativeConfig) {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true).withSpeculativeConfig(speculativeConfig);
        return new MapReadonlyAlphaTransaction(config);
    }

    @Test
    public void withNullTxObject_thenNullPointerException() {
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        long expectedVersion = this.stm.getVersion();
        try {
            tx.openForCommutingWrite(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
    }

    @Test
    public void whenExplicitReadonly_thenReadonlyException() {
        ManualRef ref = new ManualRef(this.stm, 0);
        long expectedVersion = this.stm.getVersion();
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(false, true, true, 100);
        MapReadonlyAlphaTransaction tx = this.createSutTransaction(speculativeConfig);
        tx.start();
        try {
            tx.openForCommutingWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (ReadonlyException expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
        Assert.assertTrue((boolean)speculativeConfig.isReadonly());
    }

    @Test
    public void whenSpeculativeReadonly_thenReadonlyException() {
        ManualRef ref = new ManualRef(this.stm, 0);
        long expectedVersion = this.stm.getVersion();
        SpeculativeConfiguration speculativeConfiguration = new SpeculativeConfiguration(100);
        MapReadonlyAlphaTransaction tx = this.createSutTransaction(speculativeConfiguration);
        tx.start();
        try {
            tx.openForCommutingWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
        Assert.assertFalse((boolean)speculativeConfiguration.isReadonly());
    }

    @Test
    public void whenPrepared() {
        ManualRef ref = new ManualRef(this.stm, 10);
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.prepare();
        long expectedVersion = this.stm.getVersion();
        try {
            tx.openForCommutingWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (PreparedTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm, 10);
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.commit();
        long expectedVersion = this.stm.getVersion();
        try {
            tx.openForCommutingWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm, 10);
        long expectedVersion = this.stm.getVersion();
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.abort();
        try {
            tx.openForCommutingWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
    }
}

