/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.readonly.NonTrackingReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class NonTrackingReadonlyAlphaTransaction_performanceTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;
    private int transactionCount = 200000000;
    private ReadonlyConfiguration config;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stmConfig = AlphaStmConfig.createFastConfig();
        this.stm = new AlphaStm(this.stmConfig);
        this.config = new ReadonlyConfiguration(this.stmConfig.clock, false);
    }

    public NonTrackingReadonlyAlphaTransaction createSutTransaction() {
        return new NonTrackingReadonlyAlphaTransaction(this.config);
    }

    @Test
    public void whenTransactionsNotReused() {
        ManualRef ref = new ManualRef(this.stm, 10);
        long startNs = System.nanoTime();
        long version = this.stm.getVersion();
        for (int k = 0; k < this.transactionCount; ++k) {
            NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
            tx.openForRead((AlphaTransactionalObject)ref);
            tx.commit();
            if (k % 10000000 != 0) continue;
            System.out.printf("at %s\n", k);
        }
        long periodNs = System.nanoTime() - startNs;
        double transactionPerSecond = (long)this.transactionCount * TimeUnit.SECONDS.toNanos(1L) / periodNs;
        System.out.printf("%s read-transactions/second\n", TestUtils.format((double)transactionPerSecond));
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenTransactionReused() {
        ManualRef ref = new ManualRef(this.stm, 10);
        long startNs = System.nanoTime();
        long version = this.stm.getVersion();
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        for (int k = 0; k < this.transactionCount; ++k) {
            tx.reset();
            tx.openForRead((AlphaTransactionalObject)ref);
            tx.commit();
            if (k % 10000000 != 0) continue;
            System.out.printf("at %s\n", k);
        }
        long periodNs = System.nanoTime() - startNs;
        double transactionPerSecond = (long)this.transactionCount * TimeUnit.SECONDS.toNanos(1L) / periodNs;
        System.out.printf("%s reads-transactions/second\n", TestUtils.format((double)transactionPerSecond));
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

