/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.AlphaTransactionTestUtils;
import org.multiverse.stms.alpha.transactions.update.ArrayUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class ArrayUpdateAlphaTransaction_abortTest {
    private AlphaStmConfig stmConfig;
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createFastConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public AlphaTransaction createSutTransaction(int size) {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        return new ArrayUpdateAlphaTransaction(config, size);
    }

    @Test
    public void whenUnused() {
        AlphaTransaction tx = this.createSutTransaction(10);
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenReadsAreDone() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        AlphaTransaction tx = this.createSutTransaction(10);
        tx.openForRead((AlphaTransactionalObject)ref1);
        tx.openForRead((AlphaTransactionalObject)ref2);
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenWritesAreDone() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        AlphaTransaction tx = this.createSutTransaction(10);
        tx.openForWrite((AlphaTransactionalObject)ref1);
        tx.openForWrite((AlphaTransactionalObject)ref2);
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenPendingWrite_thenWriteDiscarded() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        AlphaTransaction tx = this.createSutTransaction(10);
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ++tranlocal.value;
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)((Object)committed), (Object)ref.___load());
    }

    @Test
    public void whenListenersExists_theyAreNotNotified() {
        ManualRef ref = new ManualRef(this.stm);
        CheapLatch latch = new CheapLatch();
        AlphaTransaction listenTx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().setExplicitRetryAllowed(true).setReadTrackingEnabled(true).build().start();
        listenTx.openForRead((AlphaTransactionalObject)ref);
        listenTx.registerRetryLatch((Latch)latch);
        AlphaTransaction tx = this.createSutTransaction(10);
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ++tranlocal.value;
        tx.abort();
        AlphaTransactionTestUtils.assertHasListeners(ref, new Latch[]{latch});
    }

    @Test
    public void whenPreparedWithLockedResources_thenResourcesFreed() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.createSutTransaction(10);
        ref.inc(tx);
        tx.prepare();
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertNull((Object)ref.___getLockOwner());
    }
}

