/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRef;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.update.ArrayUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class ArrayUpdateAlphaTransaction_openForConstructionTest {
    private AlphaStmConfig stmConfig;
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public AlphaTransaction createSutTransaction(int size) {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        return new ArrayUpdateAlphaTransaction(config, size);
    }

    public AlphaTransaction createSutTransaction(SpeculativeConfiguration speculativeConfig) {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withSpeculativeConfiguration(speculativeConfig);
        return new ArrayUpdateAlphaTransaction(config, speculativeConfig.getOptimalSize());
    }

    @Test
    public void whenNullTxObject_thenNullPointerException() {
        AlphaTransaction tx = this.createSutTransaction(1);
        tx.start();
        long version = this.stm.getVersion();
        try {
            tx.openForConstruction(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenCalledForTheFirstTime() {
        ManualRef ref = ManualRef.createUncommitted();
        AlphaTransaction tx = this.createSutTransaction(1);
        long version = this.stm.getVersion();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForConstruction((AlphaTransactionalObject)ref);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNotNull((Object)((Object)tranlocal));
        Assert.assertTrue((boolean)tranlocal.isUncommitted());
        Assert.assertSame((Object)((Object)ref), (Object)tranlocal.getTransactionalObject());
        Assert.assertNull((Object)tranlocal.getOrigin());
        Assert.assertEquals((long)0L, (long)tranlocal.value);
    }

    @Test
    public void whenAlreadyOpenedForConstruction_sameInstanceReturned() {
        ManualRef ref = ManualRef.createUncommitted();
        AlphaTransaction tx = this.createSutTransaction(1);
        long version = this.stm.getVersion();
        ManualRefTranlocal firstTime = (ManualRefTranlocal)tx.openForConstruction((AlphaTransactionalObject)ref);
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForConstruction((AlphaTransactionalObject)ref);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)((Object)firstTime), (Object)((Object)found));
        Assert.assertTrue((boolean)found.isUncommitted());
        Assert.assertSame((Object)((Object)ref), (Object)found.getTransactionalObject());
        Assert.assertNull((Object)found.getOrigin());
        Assert.assertEquals((long)0L, (long)found.value);
    }

    @Test
    public void whenObjectAlreadyHasCommits_thenItWillBeOverwrittenAndNotDetected() {
        ManualRef ref = new ManualRef(this.stm);
        ref.___load();
        AlphaTransaction tx = this.createSutTransaction(10);
        long version = this.stm.getVersion();
        AlphaTranlocal opened = tx.openForConstruction((AlphaTransactionalObject)ref);
        tx.commit();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)opened, (Object)ref.___load());
    }

    @Test
    public void whenAlreadyOpenedForRead_thenIllegalStateException() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTranlocal committed = ref.___load();
        AlphaTransaction tx = this.createSutTransaction(1);
        tx.openForRead((AlphaTransactionalObject)ref);
        long version = this.stm.getVersion();
        try {
            tx.openForConstruction((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)committed, (Object)ref.___load());
    }

    @Test
    public void whenAlreadyOpenedForWrite() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTranlocal committed = ref.___load();
        AlphaTransaction tx = this.createSutTransaction(1);
        tx.openForWrite((AlphaTransactionalObject)ref);
        long version = this.stm.getVersion();
        try {
            tx.openForConstruction((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)committed, (Object)ref.___load());
    }

    @Test
    public void whenAlreadyOpenedForCommutingWrite() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 10L);
        AlphaTranlocal committed = ref.___load();
        AlphaTransaction tx = this.createSutTransaction(1);
        tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        long version = this.stm.getVersion();
        try {
            tx.openForConstruction((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)committed, (Object)ref.___load());
    }

    @Test
    public void whenMaximumCapacityExceeded_thenTransactionTooSmallError() {
        ManualRef ref1 = ManualRef.createUncommitted();
        ManualRef ref2 = ManualRef.createUncommitted();
        ManualRef ref3 = ManualRef.createUncommitted();
        ManualRef ref4 = ManualRef.createUncommitted();
        SpeculativeConfiguration config = new SpeculativeConfiguration(3);
        AlphaTransaction tx = this.createSutTransaction(config);
        tx.openForConstruction((AlphaTransactionalObject)ref1);
        tx.openForConstruction((AlphaTransactionalObject)ref2);
        System.out.println("config.optimalsize: " + config.getOptimalSize());
        tx.openForConstruction((AlphaTransactionalObject)ref3);
        long version = this.stm.getVersion();
        try {
            tx.openForConstruction((AlphaTransactionalObject)ref4);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure expected) {
            // empty catch block
        }
        Assert.assertEquals((long)5L, (long)config.getOptimalSize());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef ref = ManualRef.createUncommitted();
        AlphaTransaction tx = this.createSutTransaction(1);
        tx.abort();
        long version = this.stm.getVersion();
        try {
            tx.openForConstruction((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef ref = ManualRef.createUncommitted();
        AlphaTransaction tx = this.createSutTransaction(1);
        tx.commit();
        long version = this.stm.getVersion();
        try {
            tx.openForConstruction((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        ManualRef ref = ManualRef.createUncommitted();
        AlphaTransaction tx = this.createSutTransaction(1);
        tx.prepare();
        long version = this.stm.getVersion();
        try {
            tx.openForConstruction((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (PreparedTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

