/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.LockNotFreeReadConflict;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRef;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.update.ArrayUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class ArrayUpdateAlphaTransaction_openForReadTest {
    private AlphaStmConfig stmConfig;
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public AlphaTransaction createSutTransaction(SpeculativeConfiguration speculativeConfig) {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withMaxRetries(10).withSpeculativeConfiguration(speculativeConfig);
        return new ArrayUpdateAlphaTransaction(config, speculativeConfig.getMaximumArraySize());
    }

    public AlphaTransaction createSutTransactionWithoutAutomaticReadTracking() {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withMaxRetries(10).withReadTrackingEnabled(false);
        return new ArrayUpdateAlphaTransaction(config, 100);
    }

    public AlphaTransaction startSutTransaction() {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withMaxRetries(10);
        return new ArrayUpdateAlphaTransaction(config, 100);
    }

    @Test
    public void whenAutomaticReadTrackingDisabled_openForReadIsNotTracked() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.createSutTransactionWithoutAutomaticReadTracking();
        tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertEquals((Object)0, (Object)TestUtils.getField((Object)tx, (String)"firstFreeIndex"));
    }

    @Test
    public void whenTxObjectNull_thenNullReturned() {
        AlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal found = tx.openForRead(null);
        Assert.assertNull((Object)found);
    }

    @Test
    public void whenNotOpenedBefore_committedVersionReturned() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        AlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertTrue((boolean)found.isCommitted());
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertSame((Object)((Object)committed), (Object)((Object)found));
        TestUtils.testIncomplete();
    }

    @Test
    public void whenNotCommittedBefore_thenUncommittedReadConflict() {
        ManualRef ref = ManualRef.createUncommitted();
        AlphaTransaction tx = this.startSutTransaction();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (UncommittedReadConflict expected) {
            // empty catch block
        }
        Assert.assertNull((Object)ref.___load());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenLockedButExactVersionMatch_thenSuccess() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTranlocal readonly = ref.___load();
        AlphaTransaction owner = (AlphaTransaction)Mockito.mock(AlphaTransaction.class);
        ref.___tryLock((Transaction)owner);
        AlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal tranlocal = tx.openForRead((AlphaTransactionalObject)ref);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)readonly, (Object)tranlocal);
    }

    @Test
    public void whenLockedAndVersionTooNew_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        AlphaTransaction tx = this.startSutTransaction();
        tx.start();
        ref.set(this.stm, 10);
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenLockedAndVersionTooOld_thenLockNotFreeReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        this.stm.getClock().tick();
        AlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (LockNotFreeReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenReadConflict_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction();
        tx.start();
        ref.inc(this.stm);
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict oldVersionNotFoundReadConflict) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        TestUtils.testIncomplete();
    }

    @Test
    public void whenAlreadyOpenedForWrite_thenOpenedVersionReturned() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal expected = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)((Object)expected), (Object)((Object)found));
        TestUtils.testIncomplete();
    }

    @Test
    public void whenAlreadyOpenedForCommutingWrite() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 0L);
        AlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal openedForCommutingWrite = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        AlphaTranlocal found = tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)openedForCommutingWrite, (Object)found);
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertFalse((boolean)found.isCommitted());
    }

    @Test
    public void whenAlreadyOpenedForCommutingWriteAndLockedButVersionMatches() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 0L);
        AlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal openedForCommutingWrite = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        AlphaTranlocal found = tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)openedForCommutingWrite, (Object)found);
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertFalse((boolean)found.isCommitted());
    }

    @Test
    public void whenAlreadyOpenedForCommutingWriteAndLockedAndVersionTooOld_thenOldVersionNotFoundReadConflict() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 0L);
        AlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal openedForCommutingWrite = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        ref.atomicInc(10L);
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)this.stm.getVersion(), (long)version);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)openedForCommutingWrite.isCommuting());
    }

    @Test
    public void whenPreviouslyLoadedForRead_thenSameVersionReturned() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal expected = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)((Object)expected), (Object)((Object)found));
        TestUtils.testIncomplete();
    }

    @Test
    public void whenMultipleDifferentOpenForReads() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRefTranlocal committed1 = (ManualRefTranlocal)ref1.___load();
        ManualRef ref2 = new ManualRef(this.stm);
        ManualRefTranlocal committed2 = (ManualRefTranlocal)ref2.___load();
        AlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal found1 = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref1);
        ManualRefTranlocal found2 = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref2);
        Assert.assertSame((Object)((Object)committed1), (Object)((Object)found1));
        Assert.assertSame((Object)((Object)committed2), (Object)((Object)found2));
        TestUtils.testIncomplete();
    }

    @Test
    public void whenCapacityExceeded_thenSpeculativeConfigurationFailure() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        ManualRef ref3 = new ManualRef(this.stm);
        ManualRef ref4 = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(true, false, false, 3);
        AlphaTransaction tx = this.createSutTransaction(speculativeConfig);
        tx.openForWrite((AlphaTransactionalObject)ref1);
        tx.openForWrite((AlphaTransactionalObject)ref2);
        tx.openForWrite((AlphaTransactionalObject)ref3);
        try {
            tx.openForWrite((AlphaTransactionalObject)ref4);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)5L, (long)speculativeConfig.getOptimalSize());
    }

    @Test
    public void whenAlreadyOpenedForConstruction() {
        ManualRef ref = ManualRef.createUncommitted();
        AlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal openedForCommutingWrite = tx.openForConstruction((AlphaTransactionalObject)ref);
        AlphaTranlocal found = tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)openedForCommutingWrite, (Object)found);
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertFalse((boolean)found.isCommitted());
    }

    @Test
    public void whenAlreadyOpenedForWrite_thenNotSubjectToWriteConflict() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal expected = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ref.inc(this.stm);
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)((Object)expected), (Object)((Object)found));
    }

    @Test
    public void whenAlreadyOpenedForRead_thenNotSubjectToWriteConflict() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal expected = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        ref.inc(this.stm);
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)((Object)expected), (Object)((Object)found));
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction();
        tx.abort();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction();
        tx.commit();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction();
        tx.prepare();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (PreparedTransactionException preparedTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
    }
}

