/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.LockNotFreeReadConflict;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTestUtils;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRef;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MapUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class MapUpdateAlphaTransaction_openForReadTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MapUpdateAlphaTransaction createSutTransaction() {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withMaxRetries(10);
        return new MapUpdateAlphaTransaction(config);
    }

    public MapUpdateAlphaTransaction createSutTransactionWithoutAutomaticReadTracking() {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withMaxRetries(10).withExplictRetryAllowed(false).withReadTrackingEnabled(false);
        return new MapUpdateAlphaTransaction(config);
    }

    @Test
    public void whenAutomaticReadTrackingDisabled_openForReadIsNotTracked() {
        ManualRef ref = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransactionWithoutAutomaticReadTracking();
        tx.openForRead((AlphaTransactionalObject)ref);
        Map attachedMap = (Map)TestUtils.getField((Object)tx, (String)"attachedMap");
        Assert.assertTrue((boolean)attachedMap.isEmpty());
    }

    @Test
    public void whenNotCommittedBefore_thenUncommitted() {
        ManualRef ref = ManualRef.createUncommitted();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
        }
        catch (UncommittedReadConflict o) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertNull((Object)ref.___load());
    }

    @Test
    public void whenOpenedForRead_noLockingIsDone() {
        ManualRef ref = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ref.resetLockInfo();
        tx.openForRead((AlphaTransactionalObject)ref);
        ref.assertNoLocksReleased();
        ref.assertNoLockAcquired();
    }

    @Test
    public void whenTxObjectIsNull_thenNullReturned() {
        long expectedVersion = this.stm.getVersion();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.start();
        AlphaTranlocal result = tx.openForRead(null);
        Assert.assertNull((Object)result);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
    }

    @Test
    public void whenOpenedForRead_thenReadonlyVersionIsReturned() {
        ManualRef ref = new ManualRef(this.stm, 10);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)((Object)committed), (Object)((Object)tranlocal));
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenExactVersionMatch() {
        ManualRef ref = new ManualRef(this.stm, 0);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load(this.stm.getVersion());
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal opened = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertNotSame((Object)((Object)committed), (Object)((Object)opened));
        Assert.assertEquals((Object)((Object)ref), (Object)opened.getTransactionalObject());
        Assert.assertEquals((long)committed.value, (long)opened.value);
        Assert.assertTrue((boolean)opened.isUncommitted());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenLockedButExactVersionMatch_thenSuccess() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTranlocal readonly = ref.___load();
        AlphaTransaction owner = (AlphaTransaction)Mockito.mock(AlphaTransaction.class);
        ref.___tryLock((Transaction)owner);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal tranlocal = tx.openForRead((AlphaTransactionalObject)ref);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)readonly, (Object)tranlocal);
    }

    @Test
    public void whenLockedAndVersionTooNew_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.start();
        ref.set(this.stm, 10);
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenLockedAndVersionTooOld_thenLockNotFreeReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        this.stm.getClock().tick();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (LockNotFreeReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenVersionIsTooNew_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 0);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.start();
        ref.inc(this.stm);
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict oldVersionNotFoundReadConflict) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenLocked_thenLockNotFreeReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 0);
        this.stmConfig.clock.tick();
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        AlphaTransaction t = AlphaTestUtils.startTrackingUpdateTransaction(this.stm);
        try {
            t.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (LockNotFreeReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{t});
    }

    @Test
    public void openForReadDoesNotLockAtomicObjects() {
        ManualRef ref = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ref.resetLockInfo();
        tx.openForRead((AlphaTransactionalObject)ref);
        ref.assertNoLocksReleased();
        ref.assertNoLockAcquired();
    }

    @Test
    public void whenMultipleTransactionsAreUsedAndNoChangesAreMade_thenSameValuesAreReturned() {
        ManualRef ref = new ManualRef(this.stm, 1);
        AlphaTransaction tx1 = AlphaTestUtils.startTrackingUpdateTransaction(this.stm);
        ManualRefTranlocal found1 = (ManualRefTranlocal)tx1.openForRead((AlphaTransactionalObject)ref);
        AlphaTransaction tx2 = AlphaTestUtils.startTrackingUpdateTransaction(this.stm);
        ManualRefTranlocal found2 = (ManualRefTranlocal)tx2.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)((Object)found1), (Object)((Object)found2));
    }

    @Test
    public void whenAlreadyOpenedForRead_thenSameTranlocalReturned() {
        ManualRef ref = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal expected = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)((Object)expected), (Object)((Object)found));
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenAlreadyOpenedForWrite_thenUpdatableVersionIsReturned() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = AlphaTestUtils.startTrackingUpdateTransaction(this.stm);
        ManualRefTranlocal expected = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)((Object)expected), (Object)((Object)found));
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertFalse((boolean)found.isCommitted());
    }

    @Test
    public void whenAlreadyOpenedForCommutingWrite_thenItIsFixated() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 0L);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal openedForCommutingWrite = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        AlphaTranlocal found = tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)openedForCommutingWrite, (Object)found);
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertFalse((boolean)found.isCommitted());
    }

    @Test
    public void whenAlreadyOpenedForCommutingWriteAndLockedButVersionMatches() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 0L);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal openedForCommutingWrite = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        AlphaTranlocal found = tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)openedForCommutingWrite, (Object)found);
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertFalse((boolean)found.isCommitted());
    }

    @Test
    public void whenAlreadyOpenedForCommutingWriteAndLockedAndVersionTooOld_thenOldVersionNotFoundReadConflict() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 0L);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal openedForCommutingWrite = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        ref.atomicInc(10L);
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)this.stm.getVersion(), (long)version);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)openedForCommutingWrite.isCommuting());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm, 0);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        long expectedVersion = this.stm.getVersion();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.commit();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)((Object)committed), (Object)ref.___load());
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm, 0);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        long expectedVersion = this.stm.getVersion();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.abort();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)((Object)committed), (Object)ref.___load());
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.prepare();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (PreparedTransactionException preparedTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
    }
}

