/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.templates.EitherCallable;
import org.multiverse.templates.OrElseCallable;
import org.multiverse.templates.OrElseTransactionExecutor;
import org.multiverse.transactional.refs.IntRef;

public class OrElseTransactionExecutorTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    public Transaction startUpdateTransaction() {
        Transaction t = this.stm.getTransactionFactoryBuilder().setReadTrackingEnabled(true).setReadonly(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        return t;
    }

    @Test
    public void testUseEitherBlock() {
        final IntRef v = new IntRef(0);
        Transaction t = this.startUpdateTransaction();
        EitherCallable either = new EitherCallable(){

            public Object call(Transaction tx) throws Exception {
                v.set(10);
                return null;
            }
        };
        OrElseCallable orelse = new OrElseCallable(){

            public Object call(Transaction tx) throws Exception {
                Assert.fail((String)"OrElse cannot be called");
                return null;
            }
        };
        try {
            new OrElseTransactionExecutor(t).execute(either, orelse);
        }
        catch (Exception e) {
            Assert.fail();
        }
        t.commit();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        Assert.assertEquals((long)10L, (long)v.get());
    }

    @Test
    public void testUseOrElseBlock() {
        final IntRef v = new IntRef(0);
        Transaction t = this.startUpdateTransaction();
        EitherCallable either = new EitherCallable(){

            public Object call(Transaction tx) throws Exception {
                StmUtils.retry();
                return null;
            }
        };
        OrElseCallable orelse = new OrElseCallable(){

            public Object call(Transaction tx) throws Exception {
                v.set(10);
                return null;
            }
        };
        try {
            new OrElseTransactionExecutor(t).execute(either, orelse);
        }
        catch (Exception e) {
            Assert.fail();
        }
        t.commit();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        Assert.assertEquals((long)10L, (long)v.get());
    }

    @Test
    public void testNoChangeIfOrElseAlsoRetries() {
        IntRef v = new IntRef(0);
        Transaction t = this.startUpdateTransaction();
        EitherCallable either = new EitherCallable(){

            public Object call(Transaction tx) throws Exception {
                StmUtils.retry();
                return null;
            }
        };
        OrElseCallable orelse = new OrElseCallable(){

            public Object call(Transaction tx) throws Exception {
                StmUtils.retry();
                return null;
            }
        };
        try {
            new OrElseTransactionExecutor(t).execute(either, orelse);
        }
        catch (Retry e) {
        }
        catch (Exception e) {
            Assert.fail();
        }
        t.commit();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        Assert.assertEquals((long)0L, (long)v.get());
    }
}

