/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.templates.TransactionBoilerplate;
import org.multiverse.templates.TransactionalCallable;
import org.multiverse.transactional.refs.IntRef;

public class TransactionBoilerplateTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void testSelfCreatedTransaction() {
        final IntRef value = new IntRef(0);
        long version = this.stm.getVersion();
        new TransactionBoilerplate().execute(new TransactionalCallable(){

            public Object call(Transaction tx) {
                value.inc();
                return null;
            }
        });
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)value.get());
    }
}

