/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.RetryTimeoutException;
import org.multiverse.api.programmatic.ProgrammaticLongRef;
import org.multiverse.api.programmatic.ProgrammaticRef;
import org.multiverse.templates.TransactionTemplate;

public class TransactionTemplate_TimeoutLongTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenTimeout() {
        final ProgrammaticRef ref = this.stm.getProgrammaticRefFactoryBuilder().build().atomicCreateRef();
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setTimeoutNs(TimeUnit.SECONDS.toNanos(5L)).build();
        TransactionTemplate template = new TransactionTemplate(txFactory){

            public Object execute(Transaction tx) throws Exception {
                if (ref.isNull()) {
                    StmUtils.retry();
                }
                return null;
            }
        };
        try {
            template.execute();
            Assert.fail();
        }
        catch (RetryTimeoutException expected) {
            // empty catch block
        }
    }

    @Test
    public void whenSomeWaitingNeeded() {
        final ProgrammaticLongRef ref = this.stm.getProgrammaticRefFactoryBuilder().build().atomicCreateLongRef(0L);
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadTrackingEnabled(true).setTimeoutNs(TimeUnit.SECONDS.toNanos(60L)).build();
        TransactionTemplate template = new TransactionTemplate(txFactory){

            public Object execute(Transaction tx) throws Exception {
                if (ref.get() < 50L) {
                    StmUtils.retry();
                }
                return null;
            }
        };
        TestThread notifyThread = new TestThread(){

            public void doRun() throws Exception {
                for (int k = 0; k < 100; ++k) {
                    ref.atomicInc(1L);
                    TestUtils.sleepMs((long)100L);
                }
            }
        };
        notifyThread.start();
        template.execute();
        TestUtils.joinAll((TestThread[])new TestThread[]{notifyThread});
    }

    @Test
    public void whenMultipleWakeupsButStillTimeout() {
        final ProgrammaticLongRef ref = this.stm.getProgrammaticRefFactoryBuilder().build().atomicCreateLongRef(0L);
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setReadTrackingEnabled(true).setSpeculativeConfigurationEnabled(false).setTimeoutNs(TimeUnit.SECONDS.toNanos(5L)).build();
        TransactionTemplate template = new TransactionTemplate(txFactory){

            public Object execute(Transaction tx) throws Exception {
                if (ref.get() < 10000L) {
                    StmUtils.retry();
                }
                return null;
            }
        };
        TestThread notifyThread = new TestThread(){

            public void doRun() throws Exception {
                for (int k = 0; k < 100; ++k) {
                    ref.inc(1L);
                    TestUtils.sleepMs((long)100L);
                }
            }
        };
        notifyThread.start();
        try {
            template.execute();
            Assert.fail();
        }
        catch (RetryTimeoutException expected) {
            // empty catch block
        }
        TestUtils.joinAll((TestThread[])new TestThread[]{notifyThread});
    }
}

