/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.templates.TransactionTemplate;
import org.multiverse.transactional.refs.IntRef;

public class TransactionTemplate_conflictStressTest {
    private int threadCount = 4;
    private volatile boolean stop;
    private int refCount = 40;
    private IntRef[] refs;
    private Stm stm;
    private IncThread[] threads;

    @Before
    public void setUp() {
        this.stop = false;
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    private int sumRefs() {
        int sum = 0;
        for (IntRef ref : this.refs) {
            sum += ref.get();
        }
        return sum;
    }

    @Test
    public void test() {
        int k;
        this.refs = new IntRef[this.refCount];
        for (k = 0; k < this.refCount; ++k) {
            this.refs[k] = new IntRef();
        }
        this.threads = new IncThread[this.threadCount];
        for (k = 0; k < this.threads.length; ++k) {
            this.threads[k] = new IncThread(k);
        }
        TestUtils.startAll((TestThread[])this.threads);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)20000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])this.threads);
        Assert.assertEquals((long)(this.sum(this.threads) * (long)this.refs.length), (long)this.sumRefs());
    }

    private long sum(IncThread[] threads) {
        long result = 0L;
        for (IncThread t : threads) {
            result += t.incCount;
        }
        return result;
    }

    public class IncThread
    extends TestThread {
        private long incCount;

        public IncThread(int id) {
            super("IncThread-" + id);
        }

        public void doRun() throws Exception {
            while (!TransactionTemplate_conflictStressTest.this.stop) {
                this.action();
                ++this.incCount;
                if (this.incCount % 10000L != 0L) continue;
                System.out.printf("%s is at %s\n", this.getName(), this.incCount);
            }
        }

        public void action() {
            TransactionFactory txFactory = TransactionTemplate_conflictStressTest.this.stm.getTransactionFactoryBuilder().setReadonly(false).setFamilyName(((Object)((Object)this)).getClass() + "action()").setReadTrackingEnabled(false).build();
            new TransactionTemplate(txFactory){

                public Object execute(Transaction tx) throws Exception {
                    for (int k = 0; k < TransactionTemplate_conflictStressTest.this.refCount; ++k) {
                        TransactionTemplate_conflictStressTest.this.refs[k].inc();
                    }
                    return null;
                }
            }.execute();
        }
    }
}

