/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.templates.TransactionTemplate;
import org.multiverse.transactional.refs.IntRef;

public class TransactionTemplate_growingTransactionsTest {
    private Stm stm;
    private int refCount = 100000;
    private IntRef[] refs;
    private TransactionFactory txFactory;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.txFactory = this.stm.getTransactionFactoryBuilder().setReadonly(false).setFamilyName(this.getClass().getName()).setSpeculativeConfigurationEnabled(true).build();
        this.refs = new IntRef[this.refCount];
        for (int k = 0; k < this.refs.length; ++k) {
            this.refs[k] = new IntRef();
        }
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        new TransactionTemplate(this.txFactory){

            public Object execute(Transaction t) throws Exception {
                for (int k = 0; k < TransactionTemplate_growingTransactionsTest.this.refs.length; ++k) {
                    TransactionTemplate_growingTransactionsTest.this.refs[k].inc();
                }
                return null;
            }
        }.execute();
        for (int k = 0; k < this.refs.length; ++k) {
            Assert.assertEquals((long)1L, (long)this.refs[k].get());
        }
    }
}

