/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.TraceLevel;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.programmatic.ProgrammaticRef;
import org.multiverse.templates.TransactionTemplate;

public class TransactionTemplate_loggingTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenCourseLogging() {
        this.whenLogging(TraceLevel.course);
    }

    @Test
    public void whenFineLogging() {
        this.whenLogging(TraceLevel.fine);
    }

    @Test
    public void whenNoLogging() {
        this.whenLogging(TraceLevel.none);
    }

    public void whenLogging(TraceLevel level) {
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setTraceLevel(level).setSpeculativeConfigurationEnabled(false).setReadonly(false).setFamilyName("loggingtransaction").build();
        final ProgrammaticRef ref = this.stm.getProgrammaticRefFactoryBuilder().build().atomicCreateRef();
        new TransactionTemplate(txFactory){

            public Object execute(Transaction tx) throws Exception {
                ref.set((Object)"foo");
                return null;
            }
        }.execute();
        ref.set((Object)"banana");
    }
}

