/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.templates.TransactionTemplate;

public class TransactionTemplate_threadLocalTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenThreadLocalAwareAndNoThreadLocalTransaction_thenNewTransactionInstalled() {
        TransactionTemplate t = new TransactionTemplate(this.stm){

            public Object execute(Transaction tx) throws Exception {
                Assert.assertSame((Object)tx, (Object)ThreadLocalTransaction.getThreadLocalTransaction());
                return null;
            }
        };
        t.execute();
    }

    @Test
    public void whenThreadLocalAwareAndThreadLocalTransactionAvailable_thenNoChange() {
        final Transaction outerTx = this.stm.getTransactionFactoryBuilder().build().create();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)outerTx);
        new TransactionTemplate(this.stm){

            public Object execute(Transaction tx) throws Exception {
                Assert.assertSame((Object)outerTx, (Object)tx);
                Assert.assertSame((Object)outerTx, (Object)ThreadLocalTransaction.getThreadLocalTransaction());
                return null;
            }
        }.execute();
        Assert.assertSame((Object)outerTx, (Object)ThreadLocalTransaction.getThreadLocalTransaction());
    }

    @Test
    public void whenThreadLocalIgnoreThenNothingWrittenToThreadLocal() {
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().build();
        new TransactionTemplate<Transaction>(txFactory, false, false){

            public Transaction execute(Transaction tx) throws Exception {
                Assert.assertNotNull((Object)tx);
                Assert.assertNull((Object)ThreadLocalTransaction.getThreadLocalTransaction());
                return tx;
            }
        }.execute();
        Assert.assertNull((Object)ThreadLocalTransaction.getThreadLocalTransaction());
    }

    @Test
    public void whenThreadLocalIgnoredAndTransactionActive_thenNewTransactionCreated() {
        final Transaction active = this.stm.getTransactionFactoryBuilder().build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)active);
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().build();
        new TransactionTemplate<Transaction>(txFactory, false, false){

            public Transaction execute(Transaction tx) throws Exception {
                TestUtils.assertNotEquals((Object)active, (Object)tx);
                Assert.assertSame((Object)active, (Object)ThreadLocalTransaction.getThreadLocalTransaction());
                return tx;
            }
        }.execute();
        Assert.assertSame((Object)active, (Object)ThreadLocalTransaction.getThreadLocalTransaction());
    }
}

