/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.arrays;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.transactional.arrays.TransactionalReferenceArray;

public class TransactionalReferenceArray_atomicSetTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void whenIndexTooBig_thenIndexOutOfBoundsException() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        array.atomicSet(10, (Object)"foo");
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void whenIndexTooSmall_thenIndexOutOfBoundsException() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        array.atomicSet(-1, (Object)"foo");
    }

    @Test
    public void whenNoValueChange() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        String value = "foo";
        array.set(0, (Object)value);
        long version = this.stm.getVersion();
        String found = (String)array.atomicSet(0, (Object)value);
        Assert.assertSame((Object)value, (Object)found);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)value, (Object)array.atomicGet(0));
    }

    @Test
    public void whenValueChanged() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        String old = "foo";
        array.set(0, (Object)old);
        long version = this.stm.getVersion();
        String update = "bar";
        String found = (String)array.atomicSet(0, (Object)update);
        Assert.assertSame((Object)old, (Object)found);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)update, (Object)array.atomicGet(0));
    }

    @Test
    public void whenTransactionActiveThenIgnored() {
        Transaction tx = this.stm.getTransactionFactoryBuilder().setReadonly(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        String old = "foo";
        array.atomicSet(0, (Object)old);
        long version = this.stm.getVersion();
        String update = "bar";
        String found = (String)array.atomicSet(0, (Object)update);
        Assert.assertSame((Object)old, (Object)found);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)update, (Object)array.atomicGet(0));
    }
}

