/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_add2Test {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenIndexTooSmall_thenIndexOutOfBoundsException() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        try {
            list.add(-1, (Object)"a");
            Assert.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void whenIndexTooBig_thenIndexOutOfBoundsException() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b"});
        long version = this.stm.getVersion();
        try {
            list.add(3, (Object)"a");
            Assert.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[a, b]", (Object)list.toString());
    }

    @Test
    public void whenNullItemAdded() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        list.add(0, null);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"[null]", (Object)list.toString());
    }

    @Test
    public void whenItemAddedToEmptyList() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        list.add(0, (Object)"a");
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"[a]", (Object)list.toString());
    }

    @Test
    public void whenItemAddedToEnd() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c"});
        long version = this.stm.getVersion();
        list.add(3, (Object)"d");
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"[a, b, c, d]", (Object)list.toString());
    }

    @Test
    public void whenItemAddedInbetween() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "d", "e"});
        long version = this.stm.getVersion();
        list.add(2, (Object)"c");
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertEquals((Object)"[a, b, c, d, e]", (Object)list.toString());
    }

    @Test
    public void whenItemAddedInFront() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"b", "c", "d"});
        long version = this.stm.getVersion();
        list.add(0, (Object)"a");
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"[a, b, c, d]", (Object)list.toString());
    }
}

