/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_setPerformanceTest {
    public final long transactionCount = 10000000L;
    public final int itemCount = 1000;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        TransactionalArrayList list = new TransactionalArrayList();
        for (int k = 0; k < 1000; ++k) {
            list.add((Object)("" + k));
        }
        long startNs = System.nanoTime();
        for (long k = 0L; k < 10000000L; ++k) {
            String s = k % 2L == 0L ? "foo" : "bar";
            list.set((int)k % 1000, (Object)s);
            if (k % 10000000L != 0L) continue;
            System.out.println("at: " + k);
        }
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0E7 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", TestUtils.format((double)transactionsPerSecond));
    }
}

