/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_ProducerConsumerStressTest {
    private TransactionalLinkedList<Integer>[] queues;
    private int queueCount = 50;
    private int itemCount = 20000;
    private int delayMs = 2;
    private boolean runWithAborts;
    private int queueCapacity = 5000;
    private int concurrentHandoverCount;

    @Before
    public void setUp() {
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void testWithAborts() {
        this.runTest(true, 1);
    }

    @Test
    public void testWithoutAborts() {
        this.runTest(false, 1);
    }

    @Test
    public void testConcurrentHandoverWithAborts() {
        this.runTest(true, 2);
    }

    @Test
    public void testConcurrentHandoverWithoutAborts() {
        this.runTest(false, 2);
    }

    public void runTest(boolean runWithAborts, int concurrentHandoverCount) {
        this.runWithAborts = runWithAborts;
        this.concurrentHandoverCount = concurrentHandoverCount;
        this.queues = this.createQueues();
        ProducerThread producerThread = new ProducerThread();
        ConsumerThread consumerThread = new ConsumerThread();
        TestThread[] handoverThreads = this.createHandoverThreads(concurrentHandoverCount);
        TestUtils.startAll((TestThread[])new TestThread[]{producerThread, consumerThread});
        TestUtils.startAll((TestThread[])handoverThreads);
        TestUtils.joinAll((TestThread[])new TestThread[]{producerThread});
        TestUtils.joinAll((TestThread[])new TestThread[]{consumerThread});
        TestUtils.joinAll((TestThread[])handoverThreads);
        this.assertQueuesAreEmpty();
        if (concurrentHandoverCount == 1) {
            Assert.assertEquals((Object)producerThread.producedList, (Object)consumerThread.consumedList);
        } else {
            Assert.assertEquals(new HashSet(producerThread.producedList), new HashSet(consumerThread.consumedList));
        }
    }

    public HandoverThread[] createHandoverThreads(int concurrentHandoverCount) {
        HandoverThread[] threads = new HandoverThread[(this.queueCount - 1) * concurrentHandoverCount];
        int index = 0;
        for (int k = 0; k < this.queueCount - 1; ++k) {
            TransactionalLinkedList<Integer> from = this.queues[k];
            TransactionalLinkedList<Integer> to = this.queues[k + 1];
            AtomicInteger remainingCounter = new AtomicInteger(this.itemCount);
            AtomicInteger delay = new AtomicInteger(1);
            for (int l = 0; l < concurrentHandoverCount; ++l) {
                threads[index] = new HandoverThread(index, from, to, remainingCounter, delay);
                ++index;
            }
        }
        return threads;
    }

    public void assertQueuesAreEmpty() {
        for (TransactionalLinkedList<Integer> queue : this.queues) {
            if (queue.isEmpty()) continue;
            Assert.fail();
        }
    }

    private TransactionalLinkedList[] createQueues() {
        TransactionalLinkedList[] result = new TransactionalLinkedList[this.queueCount];
        for (int k = 0; k < this.queueCount; ++k) {
            result[k] = new TransactionalLinkedList(this.queueCapacity);
        }
        return result;
    }

    private class HandoverThread
    extends TestThread {
        private final TransactionalLinkedList<Integer> from;
        private final TransactionalLinkedList<Integer> to;
        private final AtomicInteger remainingCounter;
        private final AtomicInteger aliveCount;

        public HandoverThread(int id, TransactionalLinkedList from, TransactionalLinkedList to, AtomicInteger remainingCounter, AtomicInteger aliveCount) {
            this.setName("HandoverThread-" + id);
            this.from = from;
            this.to = to;
            this.remainingCounter = remainingCounter;
            this.aliveCount = aliveCount;
        }

        public void doRun() throws InterruptedException {
            int k = 0;
            while (this.remainingCounter.getAndDecrement() > 0) {
                boolean abort;
                if (k % 5000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                boolean bl = abort = TransactionalLinkedList_ProducerConsumerStressTest.this.runWithAborts && k % 2 == 0;
                if (abort) {
                    try {
                        this.moveOneItem(true);
                        Assert.fail();
                    }
                    catch (DeadTransactionException deadTransactionException) {
                        // empty catch block
                    }
                }
                this.moveOneItem(false);
                ++k;
            }
            this.aliveCount.decrementAndGet();
        }

        @TransactionalMethod(trackReads=true)
        public void moveOneItem(boolean abort) throws InterruptedException {
            int item = (Integer)this.from.takeLast();
            this.to.putFirst((Object)item);
            if (abort) {
                ThreadLocalTransaction.getThreadLocalTransaction().abort();
            }
        }
    }

    private class ConsumerThread
    extends TestThread {
        private final List consumedList = new LinkedList();

        public ConsumerThread() {
            this.setName("ConsumeThread");
        }

        public void doRun() throws InterruptedException {
            for (int k = 0; k < TransactionalLinkedList_ProducerConsumerStressTest.this.itemCount; ++k) {
                boolean abort;
                if (k % 5000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                boolean bl = abort = TransactionalLinkedList_ProducerConsumerStressTest.this.runWithAborts && k % 2 == 0;
                if (abort) {
                    try {
                        this.consumeOneItem(true);
                        Assert.fail();
                    }
                    catch (DeadTransactionException expected) {
                        // empty catch block
                    }
                }
                int item = this.consumeOneItem(false);
                this.consumedList.add(item);
            }
        }

        @TransactionalMethod(trackReads=true)
        public int consumeOneItem(boolean abort) throws InterruptedException {
            TransactionalLinkedList queue = TransactionalLinkedList_ProducerConsumerStressTest.this.queues[TransactionalLinkedList_ProducerConsumerStressTest.this.queues.length - 1];
            int r = (Integer)queue.takeLast();
            if (abort) {
                ThreadLocalTransaction.getThreadLocalTransaction().abort();
            }
            return r;
        }
    }

    private class ProducerThread
    extends TestThread {
        private final List<Integer> producedList;

        public ProducerThread() {
            this.producedList = new ArrayList<Integer>(TransactionalLinkedList_ProducerConsumerStressTest.this.itemCount);
            this.setName("ProducerThread");
        }

        public void doRun() throws InterruptedException {
            for (int k = 0; k < TransactionalLinkedList_ProducerConsumerStressTest.this.itemCount; ++k) {
                boolean abort;
                if (k % 5000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                boolean bl = abort = TransactionalLinkedList_ProducerConsumerStressTest.this.runWithAborts && k % 2 == 0;
                if (abort) {
                    try {
                        this.produceOneItem(k, true);
                        Assert.fail();
                    }
                    catch (DeadTransactionException deadTransactionException) {
                        // empty catch block
                    }
                }
                this.produceOneItem(k, false);
                this.producedList.add(k);
                TestUtils.sleepRandomMs((int)TransactionalLinkedList_ProducerConsumerStressTest.this.delayMs);
            }
        }

        @TransactionalMethod(trackReads=true)
        public void produceOneItem(int item, boolean abort) throws InterruptedException {
            TransactionalLinkedList queue = TransactionalLinkedList_ProducerConsumerStressTest.this.queues[0];
            queue.putFirst((Object)item);
            if (abort) {
                ThreadLocalTransaction.getThreadLocalTransaction().abort();
            }
        }
    }
}

