/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_addAllTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenNullListNullPointerException() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        list.add((Object)"2");
        long version = this.stm.getVersion();
        try {
            list.addAll(null);
            Assert.fail();
        }
        catch (NullPointerException ignore) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1, 2]", (Object)list.toString());
    }

    @Test
    public void test() {
        List<String> l = Arrays.asList("1", "2", "3");
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"a");
        list.add((Object)"b");
        long version = this.stm.getVersion();
        boolean result = list.addAll(l);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[a, b, 1, 2, 3]", (Object)list.toString());
    }

    @Test
    public void whenListEmptyItemsAreAdded() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"a");
        list.add((Object)"b");
        long version = this.stm.getVersion();
        boolean result = list.addAll(new LinkedList());
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[a, b]", (Object)list.toString());
    }

    @Test
    public void whenListIsNonEmptyItemsAreAddedToEnd() {
        List<String> l = Arrays.asList("1", "2", "3");
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        boolean result = list.addAll(l);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1, 2, 3]", (Object)list.toString());
    }

    @Test
    public void testAddAllWithIndex() {
        TestUtils.testIncomplete();
    }
}

