/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_takeLastTest {
    private Stm stm;
    private TransactionFactory updateTxFactory;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.updateTxFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).setReadTrackingEnabled(true).build();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void whenEmptyRetryErrorIsThrown() throws InterruptedException {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        Transaction t = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        try {
            list.takeLast();
            Assert.fail();
        }
        catch (Retry expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void whenSingletonTheItemIsTaken() throws InterruptedException {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        long version = this.stm.getVersion();
        String result = (String)list.takeLast();
        Assert.assertEquals((Object)"1", (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void whenMultipleItemsLastItemIsTaken() throws InterruptedException {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        list.add((Object)"2");
        long version = this.stm.getVersion();
        String result = (String)list.takeLast();
        Assert.assertEquals((Object)"2", (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
    }
}

