/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.executors;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutor;

public class TransactionalThreadPoolExecutor_exceptionsStressTest {
    private Stm stm;
    private TransactionalThreadPoolExecutor executor;
    private AtomicInteger todoCount;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.setCorePoolSize(5);
        this.todoCount = new AtomicInteger(100000);
    }

    @After
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor.awaitTerminationUninterruptibly();
        }
    }

    @Test
    public void test() throws InterruptedException {
        for (int k = 0; k < this.executor.getCorePoolSize(); ++k) {
            this.executor.execute((Runnable)new Task());
        }
        this.executor.awaitTermination();
    }

    public class Task
    implements Runnable {
        @Override
        public void run() {
            int count = TransactionalThreadPoolExecutor_exceptionsStressTest.this.todoCount.decrementAndGet();
            if (count <= 0) {
                if (count == 0) {
                    TransactionalThreadPoolExecutor_exceptionsStressTest.this.executor.shutdown();
                }
                return;
            }
            TransactionalThreadPoolExecutor_exceptionsStressTest.this.executor.execute((Runnable)new Task());
            if (TestUtils.randomOneOf((int)10)) {
                throw new RuntimeException();
            }
        }
    }
}

