/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.transactional.refs.AbaRef;

public class AbaRefTest {
    private Stm stm;
    private TransactionFactory updateTxFactory;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.updateTxFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void rollback() {
        this.rollback(null, null);
        this.rollback(null, "foo");
        this.rollback("bar", "foo");
        this.rollback("bar", null);
    }

    public void rollback(String initialValue, String newValue) {
        AbaRef ref = new AbaRef((Object)initialValue);
        long version = this.stm.getVersion();
        Transaction tx = this.stm.getTransactionFactoryBuilder().setReadonly(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        ref.set((Object)newValue);
        tx.abort();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)initialValue, (Object)ref.get());
    }

    @Test
    public void noArgConstruction() {
        long version = this.stm.getVersion();
        AbaRef ref = new AbaRef();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.get());
    }

    @Test
    public void nullConstruction() {
        long version = this.stm.getVersion();
        AbaRef ref = new AbaRef();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals(null, (Object)ref.get());
    }

    @Test
    public void nonNullConstruction() {
        long version = this.stm.getVersion();
        String s = "foo";
        AbaRef ref = new AbaRef((Object)s);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)s, (Object)ref.get());
    }

    @Test
    public void testIsNull() {
        AbaRef ref = new AbaRef();
        long version = this.stm.getVersion();
        Assert.assertTrue((boolean)ref.isNull());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        ref.set((Object)"foo");
        version = this.stm.getVersion();
        Assert.assertFalse((boolean)ref.isNull());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void testSetFromNullToNull() {
        AbaRef ref = new AbaRef();
        long version = this.stm.getVersion();
        String result = (String)ref.set(null);
        Assert.assertNull((Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.get());
    }

    @Test
    public void testSetFromNullToNonNull() {
        AbaRef ref = new AbaRef();
        long version = this.stm.getVersion();
        String newRef = "foo";
        String result = (String)ref.set((Object)newRef);
        Assert.assertNull((Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)newRef, (Object)ref.get());
    }

    @Test
    public void testSetFromNonNullToNull() {
        String oldRef = "foo";
        AbaRef ref = new AbaRef((Object)oldRef);
        long version = this.stm.getVersion();
        String result = (String)ref.set(null);
        Assert.assertSame((Object)oldRef, (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.get());
    }

    @Test
    public void testSetChangedReferenced() {
        String oldRef = "foo";
        AbaRef ref = new AbaRef((Object)oldRef);
        long version = this.stm.getVersion();
        String newRef = "bar";
        String result = (String)ref.set((Object)newRef);
        Assert.assertSame((Object)oldRef, (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)newRef, (Object)ref.get());
    }

    @Test
    public void testSetUnchangedReferences() {
        String oldRef = "foo";
        AbaRef ref = new AbaRef((Object)oldRef);
        long version = this.stm.getVersion();
        String result = (String)ref.set((Object)oldRef);
        Assert.assertSame((Object)oldRef, (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)oldRef, (Object)ref.get());
    }

    @Test
    public void testSetEqualIsNotUsedButReferenceEquality() {
        String oldRef = new String("foo");
        AbaRef ref = new AbaRef((Object)oldRef);
        long version = this.stm.getVersion();
        String newRef = new String("foo");
        String result = (String)ref.set((Object)newRef);
        Assert.assertSame((Object)oldRef, (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)newRef, (Object)ref.get());
    }

    @Test
    public void testSetAndUnsetIsSeenAsChange() {
        String oldRef = "foo";
        AbaRef ref = new AbaRef((Object)oldRef);
        long version = this.stm.getVersion();
        Transaction tx = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        String newRef = "bar";
        ref.set((Object)newRef);
        ref.set((Object)oldRef);
        tx.commit();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)oldRef, (Object)ref.get());
    }

    @Test
    public void getOrAwaitComletesIfRefNotNull() {
        String oldRef = "foo";
        AbaRef ref = new AbaRef((Object)oldRef);
        long version = this.stm.getVersion();
        String result = (String)ref.getOrAwait();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)oldRef, (Object)result);
    }

    @Test
    public void getOrAwaitRetriesIfNull() {
        AbaRef ref = new AbaRef();
        long version = this.stm.getVersion();
        Transaction tx = this.stm.getTransactionFactoryBuilder().build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        try {
            ref.getOrAwait();
            Assert.fail();
        }
        catch (Retry retry) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

