/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.transactional.refs.BasicRef;

public final class BasicRefTest {
    private Stm stm;
    private TransactionFactory txFactory;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.txFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void constructorLifts() {
        long version = this.stm.getVersion();
        Transaction tx = this.txFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        BasicRef ref = new BasicRef();
        tx.commit();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void rollback() {
        this.rollback(null, null);
        this.rollback(null, "foo");
        this.rollback("bar", "foo");
        this.rollback("bar", null);
    }

    public void rollback(String initialValue, String newValue) {
        BasicRef ref = new BasicRef((Object)initialValue);
        long version = this.stm.getVersion();
        Transaction tx = this.stm.getTransactionFactoryBuilder().setReadonly(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        ref.set((Object)newValue);
        tx.abort();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)initialValue, (Object)ref.get());
    }

    @Test
    public void noArgConstruction() {
        long version = this.stm.getVersion();
        BasicRef ref = new BasicRef();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.get());
    }

    @Test
    public void nullConstruction() {
        long version = this.stm.getVersion();
        BasicRef ref = new BasicRef();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.get());
    }

    @Test
    public void nonNullConstruction() {
        long version = this.stm.getVersion();
        String s = "foo";
        BasicRef ref = new BasicRef((Object)s);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)s, (Object)ref.get());
    }

    @Test
    public void testIsNull() {
        BasicRef ref = new BasicRef();
        long version = this.stm.getVersion();
        Assert.assertTrue((boolean)ref.isNull());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        ref.set((Object)"foo");
        version = this.stm.getVersion();
        Assert.assertFalse((boolean)ref.isNull());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void testSetFromNullToNull() {
        BasicRef ref = new BasicRef();
        long version = this.stm.getVersion();
        String result = (String)ref.set(null);
        Assert.assertNull((Object)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.get());
    }

    @Test
    public void testSetFromNullToNonNull() {
        BasicRef ref = new BasicRef();
        long version = this.stm.getVersion();
        String newRef = "foo";
        String result = (String)ref.set((Object)newRef);
        Assert.assertNull((Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)newRef, (Object)ref.get());
    }

    @Test
    public void testSetFromNonNullToNull() {
        String oldRef = "foo";
        BasicRef ref = new BasicRef((Object)oldRef);
        long version = this.stm.getVersion();
        String result = (String)ref.set(null);
        Assert.assertSame((Object)oldRef, (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.get());
    }

    @Test
    public void testSetChangedReferenced() {
        String oldRef = "foo";
        BasicRef ref = new BasicRef((Object)oldRef);
        long version = this.stm.getVersion();
        String newRef = "bar";
        String result = (String)ref.set((Object)newRef);
        Assert.assertSame((Object)oldRef, (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)newRef, (Object)ref.get());
    }

    @Test
    public void testSetUnchangedReferences() {
        String oldRef = "foo";
        BasicRef ref = new BasicRef((Object)oldRef);
        long version = this.stm.getVersion();
        String result = (String)ref.set((Object)oldRef);
        Assert.assertSame((Object)oldRef, (Object)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)oldRef, (Object)ref.get());
    }

    @Test
    public void testSetEqualIsNotUsedButReferenceEquality() {
        String oldRef = new String("foo");
        BasicRef ref = new BasicRef((Object)oldRef);
        long version = this.stm.getVersion();
        String newRef = new String("foo");
        String result = (String)ref.set((Object)newRef);
        Assert.assertSame((Object)oldRef, (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)newRef, (Object)ref.get());
    }

    @Test
    public void testSetAndUnsetIsNotSeenAsChange() {
        String oldRef = "foo";
        BasicRef ref = new BasicRef((Object)oldRef);
        long version = this.stm.getVersion();
        Transaction tx = this.stm.getTransactionFactoryBuilder().setReadonly(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        String newRef = "bar";
        ref.set((Object)newRef);
        ref.set((Object)oldRef);
        tx.commit();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)oldRef, (Object)ref.get());
    }

    @Test
    public void getOrAwaitCompletesIfRefNotNull() {
        String oldRef = "foo";
        BasicRef ref = new BasicRef((Object)oldRef);
        long version = this.stm.getVersion();
        String result = (String)ref.getOrAwait();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)oldRef, (Object)result);
    }

    @Test
    public void getOrAwaitRetriesIfNull() {
        BasicRef ref = new BasicRef();
        long version = this.stm.getVersion();
        Transaction t = this.stm.getTransactionFactoryBuilder().build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        try {
            ref.getOrAwait();
            Assert.fail();
        }
        catch (Retry retry) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

