/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.refs.BooleanRef;
import org.multiverse.transactional.refs.CharRef;

public class BooleanRefTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void constructorWithNoArg() {
        BooleanRef ref = new BooleanRef();
        Assert.assertFalse((boolean)ref.get());
    }

    @Test
    public void constructorWithSingleArg() {
        Assert.assertTrue((boolean)new BooleanRef(true).get());
        Assert.assertFalse((boolean)new BooleanRef(false).get());
    }

    @Test
    public void set() {
        CharRef ref = new CharRef('\n');
        long old = ref.set('d');
        Assert.assertEquals((long)10L, (long)old);
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testEquals() {
        BooleanRef ref1 = new BooleanRef(true);
        BooleanRef ref2 = new BooleanRef(true);
        BooleanRef ref3 = new BooleanRef(false);
        Assert.assertFalse((boolean)ref1.equals(null));
        Assert.assertFalse((boolean)ref1.equals((Object)""));
        Assert.assertTrue((boolean)ref1.equals((Object)ref2));
        Assert.assertTrue((boolean)ref2.equals((Object)ref1));
        Assert.assertTrue((boolean)ref1.equals((Object)ref1));
        Assert.assertFalse((boolean)ref1.equals((Object)ref3));
        Assert.assertFalse((boolean)ref3.equals((Object)ref1));
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)1L, (long)new BooleanRef(true).hashCode());
        Assert.assertEquals((long)0L, (long)new BooleanRef(false).hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"BooleanRef(value=true)", (Object)new BooleanRef(true).toString());
        Assert.assertEquals((Object)"BooleanRef(value=false)", (Object)new BooleanRef(false).toString());
    }

    @Test
    public void testAtomic() {
        BooleanRef ref1 = new BooleanRef(true);
        BooleanRef ref2 = new BooleanRef(false);
        try {
            this.flipButAbort(ref1, ref2);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)ref1.get());
        Assert.assertFalse((boolean)ref2.get());
    }

    @TransactionalMethod
    public void flipButAbort(BooleanRef ... refs) {
        for (BooleanRef ref : refs) {
            ref.set(!ref.get());
        }
        ThreadLocalTransaction.getThreadLocalTransaction().abort();
    }
}

