/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.transactional.refs.BooleanRef;
import org.multiverse.transactional.refs.LongRef;

public class LongRefBlockingStressTest {
    private AlphaStm stm;
    private LongRef ref;
    private BooleanRef completedRef;
    private int consumerCount = 10;
    private int unprocessedCapacity = 1000;
    private volatile boolean stop;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stop = false;
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        this.ref = new LongRef();
        this.completedRef = new BooleanRef();
    }

    @Test
    public void test() {
        TestThread[] producers = new ProducerThread[this.consumerCount];
        for (int k = 0; k < producers.length; ++k) {
            producers[k] = new ProducerThread(k);
        }
        TestThread[] consumers = new ConsumerThread[this.consumerCount];
        for (int k = 0; k < producers.length; ++k) {
            consumers[k] = new ConsumerThread(k);
        }
        TestUtils.startAll((TestThread[])producers);
        TestUtils.startAll((TestThread[])consumers);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])producers);
        TestUtils.joinAll((TestThread[])consumers);
        long produceCount = this.sum((ProducerThread[])producers);
        long consumeCount = this.sum((ConsumerThread[])consumers);
        long leftOver = this.ref.get();
        Assert.assertEquals((long)produceCount, (long)(consumeCount + leftOver));
    }

    long sum(ProducerThread[] threads) {
        long result = 0L;
        for (ProducerThread thread : threads) {
            result += thread.count;
        }
        return result;
    }

    long sum(ConsumerThread[] threads) {
        long result = 0L;
        for (ConsumerThread thread : threads) {
            result += thread.count;
        }
        return result;
    }

    class ConsumerThread
    extends TestThread {
        long count;

        public ConsumerThread(int id) {
            super("ConsumerThread-" + id);
            this.count = 0L;
        }

        public void doRun() throws Exception {
            boolean again;
            do {
                again = this.consume();
                if (this.count % 100000L == 0L) {
                    System.out.printf("%s is at %s\n", this.getName(), this.count);
                }
                if (!again) continue;
                ++this.count;
            } while (again);
        }

        @TransactionalMethod(readonly=false)
        private boolean consume() {
            if (LongRefBlockingStressTest.this.completedRef.get()) {
                return false;
            }
            long value = LongRefBlockingStressTest.this.ref.get();
            if (value == 0L) {
                StmUtils.retry();
            }
            LongRefBlockingStressTest.this.ref.inc(-1L);
            return true;
        }
    }

    class ProducerThread
    extends TestThread {
        long count;

        public ProducerThread(int id) {
            super("ProducerThread-" + id);
            this.count = 0L;
        }

        public void doRun() throws Exception {
            while (!LongRefBlockingStressTest.this.stop) {
                if (this.produce()) {
                    ++this.count;
                }
                if (this.count % 100000L != 0L) continue;
                System.out.printf("%s is at %s\n", this.getName(), this.count);
            }
            LongRefBlockingStressTest.this.completedRef.set(true);
        }

        @TransactionalMethod(readonly=false)
        private boolean produce() {
            if (LongRefBlockingStressTest.this.completedRef.get()) {
                return false;
            }
            long value = LongRefBlockingStressTest.this.ref.get();
            if (value >= (long)LongRefBlockingStressTest.this.unprocessedCapacity) {
                StmUtils.retry();
            }
            LongRefBlockingStressTest.this.ref.inc();
            return true;
        }
    }
}

