/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.tranlocal;

import org.multiverse.instrumentation.AbstractInstrumentationPhase;
import org.multiverse.instrumentation.Clazz;
import org.multiverse.instrumentation.Environment;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.stms.alpha.instrumentation.tranlocal.TranlocalFactory;
import org.objectweb.asm.tree.ClassNode;

public final class TranlocalInstrumentationPhase
extends AbstractInstrumentationPhase {
    public TranlocalInstrumentationPhase() {
        super("TranlocalInstrumentationPhase");
    }

    protected Clazz doInstrument(Environment environment, Clazz originalClazz) {
        ClassLoader classLoader = originalClazz.getClassLoader();
        ClassMetadata classMetadata = environment.getMetadataRepository().loadClassMetadata(classLoader, originalClazz.getName());
        if (!classMetadata.isTransactionalObjectWithObjectGranularFields()) {
            return originalClazz;
        }
        ClassNode originalClassNode = AsmUtils.loadAsClassNode((byte[])originalClazz.getBytecode());
        TranlocalFactory transformer = new TranlocalFactory(classLoader, originalClassNode, environment.getMetadataRepository());
        ClassNode result = transformer.create();
        Clazz tranlocalClazz = new Clazz(classMetadata.getTranlocalName());
        tranlocalClazz.setBytecode(AsmUtils.toBytecode((ClassNode)result));
        tranlocalClazz.setClassLoader(originalClazz.getClassLoader());
        environment.getFiler().createClassFile(tranlocalClazz);
        return originalClazz;
    }
}

