/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.transactionalmethod;

import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.ConstructorCantRetryException;
import org.multiverse.api.exceptions.ControlFlowError;
import org.multiverse.api.exceptions.RetryTimeoutException;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.api.latches.StandardLatch;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;

public class TransactionLogicDonor {
    public static TransactionFactory transactionFactory;

    public static void execute___ro() {
    }

    public static void execute___up() {
    }

    public static void donorConstructor() throws Exception {
        AlphaTransaction tx = (AlphaTransaction)ThreadLocalTransaction.getThreadLocalTransaction();
        if (TransactionLogicDonor.isActiveTransaction(tx)) {
            TransactionLogicDonor.execute___up();
            return;
        }
        tx = TransactionLogicDonor.createTransaction(tx, transactionFactory);
        tx.setAttempt(1);
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        try {
            TransactionLogicDonor.execute___ro();
            tx.commit();
            tx = null;
        }
        catch (Throwable throwable) {
            tx.abort();
            if (throwable instanceof ControlFlowError) {
                throw new ConstructorCantRetryException();
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw (Exception)throwable;
        }
        finally {
            ThreadLocalTransaction.clearThreadLocalTransaction();
        }
    }

    /*
     * Exception decompiling
     */
    public static void donorMethod() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static AlphaTransaction handleSpeculativeFailure(TransactionFactory transactionFactory, AlphaTransaction oldTx) {
        oldTx.abort();
        AlphaTransaction newTx = (AlphaTransaction)transactionFactory.create();
        newTx.setRemainingTimeoutNs(oldTx.getRemainingTimeoutNs());
        newTx.setAttempt(oldTx.getAttempt());
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)newTx);
        return newTx;
    }

    public static void handleRetry(AlphaTransaction tx) throws InterruptedException {
        if (tx.getAttempt() - 1 < tx.getConfiguration().getMaxRetries()) {
            Object latch = tx.getRemainingTimeoutNs() == Long.MAX_VALUE ? new CheapLatch() : new StandardLatch();
            tx.registerRetryLatch((Latch)latch);
            tx.abort();
            if (tx.getRemainingTimeoutNs() == Long.MAX_VALUE) {
                if (tx.getConfiguration().isInterruptible()) {
                    latch.await();
                } else {
                    latch.awaitUninterruptible();
                }
            } else {
                long beginNs = System.nanoTime();
                boolean timeout = tx.getConfiguration().isInterruptible() ? !latch.tryAwaitNs(tx.getRemainingTimeoutNs()) : !latch.tryAwaitNs(tx.getRemainingTimeoutNs());
                long durationNs = System.nanoTime() - beginNs;
                tx.setRemainingTimeoutNs(tx.getRemainingTimeoutNs() - durationNs);
                if (timeout) {
                    String msg = String.format("Transaction %s has timed out with a total timeout of %s ns", tx.getConfiguration().getFamilyName(), tx.getConfiguration().getTimeoutNs());
                    throw new RetryTimeoutException(msg);
                }
            }
            tx.reset();
        }
    }

    public static AlphaTransaction createTransaction(AlphaTransaction tx, TransactionFactory transactionFactory) {
        if (tx != null && tx.getTransactionFactory() == transactionFactory) {
            tx.reset();
            tx.setAttempt(0);
            tx.setRemainingTimeoutNs(tx.getConfiguration().getTimeoutNs());
        } else {
            tx = (AlphaTransaction)transactionFactory.create();
        }
        return tx;
    }

    public static boolean isActiveTransaction(AlphaTransaction t) {
        return t != null && !t.getStatus().isDead();
    }
}

