/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.stms.AbstractTransactionSnapshot;
import org.multiverse.stms.alpha.AlphaStmUtils;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.transactions.AbstractAlphaTransaction;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public abstract class AbstractReadonlyAlphaTransaction
extends AbstractAlphaTransaction<ReadonlyConfiguration, AbstractTransactionSnapshot> {
    public AbstractReadonlyAlphaTransaction(ReadonlyConfiguration config) {
        super(config);
    }

    protected abstract AlphaTranlocal findAttached(AlphaTransactionalObject var1);

    protected abstract void attach(AlphaTranlocal var1);

    @Override
    protected final AlphaTranlocal doOpenForRead(AlphaTransactionalObject transactionalObject) {
        AlphaTranlocal tranlocal = this.findAttached(transactionalObject);
        if (tranlocal == null) {
            tranlocal = this.load(transactionalObject);
            if (tranlocal == null) {
                throw this.createUncommittedException(transactionalObject);
            }
            if (((ReadonlyConfiguration)this.config).readTrackingEnabled) {
                this.attach(tranlocal);
            }
        }
        return tranlocal;
    }

    @Override
    public AlphaTranlocal doOpenForCommutingWrite(AlphaTransactionalObject transactionalObject) {
        return this.doOpenForWrite(transactionalObject);
    }

    @Override
    public AlphaTranlocal doOpenForConstruction(AlphaTransactionalObject transactionalObject) {
        return this.doOpenForWrite(transactionalObject);
    }

    @Override
    protected final AlphaTranlocal doOpenForWrite(AlphaTransactionalObject transactionalObject) {
        SpeculativeConfiguration speculativeConfig = ((ReadonlyConfiguration)this.config).speculativeConfiguration;
        if (speculativeConfig.isSpeculativeReadonlyEnabled()) {
            speculativeConfig.signalSpeculativeReadonlyFailure();
            throw SpeculativeConfigurationFailure.create();
        }
        String msg = String.format("Can't open for write transactional object '%s' because transaction '%s' is readonly'", AlphaStmUtils.toTxObjectString(transactionalObject), ((ReadonlyConfiguration)this.config).getFamilyName());
        throw new ReadonlyException(msg);
    }
}

