/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.benchmarks;

import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.ThreadLocalTransaction;

public class ReadPerformanceTest {
    private long readCount;
    private boolean readonly;
    private ReadThread[] threads;
    private Ref ref;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.readCount = 100000000L;
        this.readonly = true;
        this.ref = new Ref();
    }

    @Test
    public void test_1() {
        this.test(1);
    }

    @Test
    public void test_2() {
        this.test(2);
    }

    @Test
    public void test_4() {
        this.test(4);
    }

    @Test
    public void test_8() {
        this.test(8);
    }

    @Test
    public void test_16() {
        this.test(16);
    }

    public void test(int threadCount) {
        this.threads = new ReadThread[threadCount];
        for (int k = 0; k < this.threads.length; ++k) {
            this.threads[k] = new ReadThread(k);
        }
        long startNs = System.nanoTime();
        TestUtils.startAll((TestThread[])this.threads);
        TestUtils.joinAll((TestThread[])this.threads);
        long transactionCount = (long)threadCount * this.readCount;
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)transactionCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", TestUtils.format((double)transactionsPerSecond));
    }

    @TransactionalObject
    static class Ref {
        private int value;

        Ref() {
        }

        public int get() {
            return this.value;
        }

        public void set(int newValue) {
            this.value = this.value;
        }
    }

    public class ReadThread
    extends TestThread {
        public ReadThread(int id) {
            super("ReadThread-" + id);
        }

        public void doRun() throws Exception {
            int k = 0;
            while ((long)k < ReadPerformanceTest.this.readCount) {
                if (k % 1000000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                if (ReadPerformanceTest.this.readonly) {
                    this.readInReadonlyMode();
                } else {
                    this.readInUpdateMode();
                }
                ++k;
            }
        }

        @TransactionalMethod(readonly=true)
        public int readInReadonlyMode() {
            return ReadPerformanceTest.this.ref.get();
        }

        @TransactionalMethod(readonly=false)
        public int readInUpdateMode() {
            return ReadPerformanceTest.this.ref.get();
        }
    }
}

