/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.benchmarks.programmatic;

import java.util.concurrent.TimeUnit;
import org.benchy.AbstractBenchmarkDriver;
import org.benchy.DriverParameter;
import org.benchy.TestCase;
import org.benchy.TestCaseResult;
import org.junit.Assert;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.programmatic.ProgrammaticLongRef;

public class ConcurrentUpdateDriver
extends AbstractBenchmarkDriver {
    @DriverParameter
    private long incCountPerThread;
    @DriverParameter
    private int threadCount;
    private IncThread[] threads;
    private ProgrammaticLongRef ref;
    private Stm stm;

    public void preRun(TestCase testCase) {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.threads = new IncThread[this.threadCount];
        for (int k = 0; k < this.threads.length; ++k) {
            this.threads[k] = new IncThread(k);
        }
        this.ref = this.stm.getProgrammaticRefFactoryBuilder().build().atomicCreateLongRef(0L);
    }

    public void run() {
        TestUtils.startAll((TestThread[])this.threads);
        TestUtils.joinAll((TestThread[])this.threads);
        Assert.assertEquals((long)(this.incCountPerThread * (long)this.threadCount), (long)this.ref.get());
    }

    public void postRun(TestCaseResult caseResult) {
        long transactionCount = this.incCountPerThread * (long)this.threadCount;
        caseResult.put("transactionCount", (Object)transactionCount);
        double transactionsPerSecond = 1.0 * (double)transactionCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)caseResult.getLongProperty("duration(ns)");
        caseResult.put("transactions/second", (Object)transactionsPerSecond);
        double transactionsPerSecondPerThread = transactionsPerSecond / (double)this.threadCount;
        caseResult.put("transactions/s/thread", (Object)transactionsPerSecondPerThread);
    }

    public class IncThread
    extends TestThread {
        public IncThread(int id) {
            super("IncThread-" + id);
        }

        public void doRun() throws Exception {
            int k = 0;
            while ((long)k < ConcurrentUpdateDriver.this.incCountPerThread) {
                if (k % 1000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ConcurrentUpdateDriver.this.ref.inc(1L);
                ++k;
            }
        }
    }
}

