/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.commitbarriers.CountDownCommitBarrier;
import org.multiverse.transactional.refs.IntRef;

public class CountDownCommitBarrier_IntegrationTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void testMultipleWaiters() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(2);
        AwaitThread t1 = new AwaitThread(barrier);
        t1.start();
        TestUtils.sleepMs((long)1000L);
        Assert.assertTrue((boolean)t1.isAlive());
        AwaitThread t2 = new AwaitThread(barrier);
        t2.start();
        TestUtils.joinAll((TestThread[])new TestThread[]{t1, t2});
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{t2.tx});
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{t1.tx});
    }

    @Test
    public void testSingleWaiter() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        AwaitThread t1 = new AwaitThread(barrier);
        t1.start();
        TestUtils.joinAll((TestThread[])new TestThread[]{t1});
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        Assert.assertTrue((boolean)barrier.isCommitted());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{t1.tx});
    }

    public class AwaitThread
    extends TestThread {
        private Transaction tx;
        private final CountDownCommitBarrier barrier;

        public AwaitThread(CountDownCommitBarrier barrier) {
            super("AwaitThread");
            this.barrier = barrier;
        }

        @TransactionalMethod
        public void doRun() throws Exception {
            IntRef dummy = new IntRef();
            this.tx = ThreadLocalTransaction.getThreadLocalTransaction();
            this.barrier.joinCommitUninterruptibly(this.tx);
        }
    }
}

