/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.CountDownCommitBarrier;
import org.multiverse.commitbarriers.JoinCommitThread;
import org.multiverse.stms.AbstractTransactionImpl;

public class CountDownCommitBarrier_incPartiesWithTransactionTest {
    @Test
    public void whenNegativeNumber_thenIllegalArgumentException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(10);
        try {
            barrier.incParties(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        Assert.assertEquals((long)10L, (long)barrier.getParties());
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenNullTransaction_thenNullPointerException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(10);
        try {
            barrier.incParties(null, 1);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        Assert.assertEquals((long)10L, (long)barrier.getParties());
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenTransactionPrepared() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(10);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.prepare();
        barrier.incParties((Transaction)tx, 5);
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        Assert.assertEquals((long)15L, (long)barrier.getParties());
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenTransactionAborted_thenDeadTransactionException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(10);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.abort();
        try {
            barrier.incParties((Transaction)tx, 1);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        Assert.assertEquals((long)10L, (long)barrier.getParties());
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenTransactionCommitted_thenDeadTransactionException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(10);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.commit();
        try {
            barrier.incParties((Transaction)tx, 1);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        Assert.assertEquals((long)10L, (long)barrier.getParties());
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenZeroExtraParties() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(5);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        barrier.incParties((Transaction)tx, 0);
        Assert.assertEquals((long)5L, (long)barrier.getParties());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenPositiveNumber() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(10);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        barrier.incParties((Transaction)tx, 5);
        TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        Assert.assertEquals((long)15L, (long)barrier.getParties());
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenPartiesAdded_thenAdditionalJoinsNeedToBeExecuted() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(2);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        barrier.incParties((Transaction)tx, 1);
        barrier.countDown();
        barrier.countDown();
        Assert.assertTrue((boolean)barrier.isClosed());
        barrier.countDown();
        Assert.assertTrue((boolean)barrier.isCommitted());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
    }

    @Test
    public void whenTransactionAborted_thenPartiesRestored() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(2);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        barrier.incParties((Transaction)tx, 10);
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)barrier.isClosed());
        Assert.assertEquals((long)2L, (long)barrier.getParties());
    }

    @Test
    public void whenPendingTransactions() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(3);
        JoinCommitThread t1 = new JoinCommitThread(barrier);
        JoinCommitThread t2 = new JoinCommitThread(barrier);
        TestUtils.startAll((TestThread[])new TestThread[]{t1, t2});
        TestUtils.sleepMs((long)300L);
        barrier.incParties(2);
        TestUtils.sleepMs((long)300L);
        TestUtils.assertAlive((Thread[])new Thread[]{t1, t2});
        Assert.assertEquals((long)2L, (long)barrier.getNumberWaiting());
        Assert.assertEquals((long)5L, (long)barrier.getParties());
    }

    @Test
    public void whenAborted_thenCommitBarrierOpenException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        barrier.abort();
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        try {
            barrier.incParties((Transaction)tx, 10);
            Assert.fail((String)"Should have got CommitBarrierOpenException");
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)barrier.getParties());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        Assert.assertTrue((boolean)barrier.isAborted());
    }

    @Test
    public void whenCommitted_thenCommitBarrierOpenException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(0);
        Transaction tx = (Transaction)Mockito.spy((Object)new AbstractTransactionImpl());
        try {
            barrier.incParties(tx, 1);
            Assert.fail((String)"Should have got CommitBarrierOpenException");
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)barrier.getParties());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        Assert.assertTrue((boolean)barrier.isCommitted());
    }
}

