/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.CountDownCommitBarrier;
import org.multiverse.stms.AbstractTransactionImpl;

public class CountDownCommitBarrier_joinCommitUninterruptiblyTest {
    private CountDownCommitBarrier barrier;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenOpenAndNullTransaction_thenNullPointerException() {
        this.barrier = new CountDownCommitBarrier(1);
        try {
            this.barrier.joinCommitUninterruptibly(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isClosed());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    public void whenOpenAndThreadAlreadyInterrupted_thenNotInterruptedButInterruptStatusIsSet() {
        this.barrier = new CountDownCommitBarrier(1);
        Thread.currentThread().interrupt();
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        this.barrier.joinCommitUninterruptibly((Transaction)tx);
        Assert.assertTrue((boolean)this.barrier.isCommitted());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
        Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
    }

    @Test
    public void whenOpenAndTransactionActive() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.prepare();
        this.barrier = new CountDownCommitBarrier(1);
        this.barrier.joinCommitUninterruptibly((Transaction)tx);
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)this.barrier.isCommitted());
    }

    @Test
    @Ignore
    public void whenOpenAndTransactionPrepared() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.prepare();
        this.barrier = new CountDownCommitBarrier(1);
        this.barrier.joinCommitUninterruptibly((Transaction)tx);
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)this.barrier.isCommitted());
    }

    @Test
    public void whenOpenAndLastTransaction_thenAllTransactionsCommitted() {
        this.barrier = new CountDownCommitBarrier(3);
        AwaitThread t1 = new AwaitThread();
        AwaitThread t2 = new AwaitThread();
        TestUtils.startAll((TestThread[])new TestThread[]{t1, t2});
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t1, t2});
        Assert.assertTrue((boolean)this.barrier.isClosed());
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        this.barrier.joinCommitUninterruptibly((Transaction)tx);
        TestUtils.joinAll((TestThread[])new TestThread[]{t1, t2});
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx, t1.tx, t2.tx});
    }

    @Test
    public void whenOpenAndTransactionAborted_thenIllegalStateException() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.abort();
        this.barrier = new CountDownCommitBarrier(1);
        try {
            this.barrier.joinCommitUninterruptibly((Transaction)tx);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isClosed());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    public void whenOpenAndTransactionCommitted_thenIllegalStateException() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.commit();
        this.barrier = new CountDownCommitBarrier(1);
        try {
            this.barrier.joinCommitUninterruptibly((Transaction)tx);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isClosed());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    public void whenAborted_thenCommitBarrierOpenException() {
        this.barrier = new CountDownCommitBarrier(1);
        this.barrier.abort();
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        try {
            this.barrier.joinCommitUninterruptibly((Transaction)tx);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isAborted());
    }

    @Test
    public void whenCommitted_thenCommitBarrierOpenException() {
        this.barrier = new CountDownCommitBarrier(1);
        this.barrier.joinCommitUninterruptibly((Transaction)new AbstractTransactionImpl());
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        try {
            this.barrier.joinCommitUninterruptibly((Transaction)tx);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }

    class AwaitThread
    extends TestThread {
        private Transaction tx;

        AwaitThread() {
        }

        @TransactionalMethod
        public void doRun() throws Exception {
            this.tx = ThreadLocalTransaction.getThreadLocalTransaction();
            CountDownCommitBarrier_joinCommitUninterruptiblyTest.this.barrier.joinCommitUninterruptibly(this.tx);
        }
    }
}

