/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.commitbarriers.CountDownCommitBarrier;

public class CountDownCommitBarrier_tryAwaitOpenTest {
    private CountDownCommitBarrier barrier;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenNullTimeUnit_thenNullPointerException() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(1);
        try {
            this.barrier.tryAwaitOpen(10L, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isClosed());
    }

    @Test
    public void whenNegativeTimeoutAndBufferedOpen() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(1);
        boolean result = this.barrier.tryAwaitOpen(-1L, TimeUnit.DAYS);
        Assert.assertFalse((boolean)result);
        Assert.assertTrue((boolean)this.barrier.isClosed());
    }

    @Test
    public void whenAbortedWhileWaiting() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(2);
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                boolean success = CountDownCommitBarrier_tryAwaitOpenTest.this.barrier.tryAwaitOpen(1L, TimeUnit.DAYS);
                Assert.assertTrue((boolean)success);
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        this.barrier.abort();
        t.join();
        t.assertNothingThrown();
        Assert.assertTrue((boolean)this.barrier.isAborted());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    public void whenCommittedWhileWaiting() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(1);
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                boolean success = CountDownCommitBarrier_tryAwaitOpenTest.this.barrier.tryAwaitOpen(1L, TimeUnit.DAYS);
                Assert.assertTrue((boolean)success);
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        this.barrier.countDown();
        t.join();
        t.assertNothingThrown();
        Assert.assertTrue((boolean)this.barrier.isCommitted());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    public void whenInterruptedWhileWaiting() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(2);
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                CountDownCommitBarrier_tryAwaitOpenTest.this.barrier.tryAwaitOpen(1L, TimeUnit.DAYS);
                Assert.fail();
            }
        };
        t.setPrintStackTrace(false);
        t.start();
        TestUtils.sleepMs((long)500L);
        t.interrupt();
        t.join();
        t.assertFailedWithException(InterruptedException.class);
        Assert.assertTrue((boolean)this.barrier.isClosed());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    public void whenTimeoutWhileWaiting() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(2);
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                boolean success = CountDownCommitBarrier_tryAwaitOpenTest.this.barrier.tryAwaitOpen(1L, TimeUnit.SECONDS);
                Assert.assertFalse((boolean)success);
            }
        };
        t.start();
        t.join();
        Assert.assertTrue((boolean)this.barrier.isClosed());
    }

    @Test
    public void whenAborted() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(1);
        this.barrier.abort();
        boolean result = this.barrier.tryAwaitOpen(1L, TimeUnit.DAYS);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((boolean)this.barrier.isAborted());
    }

    @Test
    public void whenCommitted() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(0);
        boolean result = this.barrier.tryAwaitOpen(1L, TimeUnit.DAYS);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((boolean)this.barrier.isCommitted());
    }
}

