/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.CountDownCommitBarrier;
import org.multiverse.stms.AbstractTransactionImpl;

public class CountDownCommitBarrier_tryJoinCommitTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenOpenAndNullTransaction_thenNullPointerException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        try {
            barrier.tryJoinCommit(null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isClosed());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
    }

    @Test
    public void whenOpenAndTransactionCommitted_thenIllegalStateException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.commit();
        try {
            barrier.tryJoinCommit((Transaction)tx);
            Assert.fail((String)"Expected Illegal state exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isClosed());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
    }

    @Test
    public void whenOpenAndTransactionAborted_thenIllegalStateException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.abort();
        try {
            barrier.tryJoinCommit((Transaction)tx);
            Assert.fail((String)"Expected Illegal state exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isClosed());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
    }

    @Test
    public void whenAborted_thenCommitBarrierOpenException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        barrier.abort();
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        try {
            barrier.tryJoinCommit((Transaction)tx);
            Assert.fail((String)"Expecting CommitBarrierOpenException");
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isAborted());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenCommitted_thenCommitBarrierOpenException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(0);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        try {
            barrier.tryJoinCommit((Transaction)tx);
            Assert.fail((String)"Expected CommitBarrierOpenException");
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isCommitted());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }
}

