/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.commitbarriers.VetoCommitBarrier;
import org.multiverse.transactional.refs.IntRef;

public class VetoCommitBarrier_integrationTest {
    private VetoCommitBarrier barrier;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void test() throws InterruptedException {
        this.barrier = new VetoCommitBarrier();
        IntRef ref1 = new IntRef();
        IntRef ref2 = new IntRef();
        CommitThread t1 = new CommitThread(1, ref1);
        CommitThread t2 = new CommitThread(2, ref2);
        TestUtils.startAll((TestThread[])new TestThread[]{t1, t2});
        TestUtils.sleepMs((long)1000L);
        this.barrier.vetoCommit();
        TestUtils.joinAll((TestThread[])new TestThread[]{t1, t2});
        Assert.assertEquals((long)1L, (long)ref1.get());
        Assert.assertEquals((long)1L, (long)ref2.get());
    }

    @Test
    public void testAbort() throws InterruptedException {
        this.barrier = new VetoCommitBarrier();
        IntRef ref1 = new IntRef();
        IntRef ref2 = new IntRef();
        CommitThread t1 = new CommitThread(1, ref1);
        t1.setPrintStackTrace(false);
        CommitThread t2 = new CommitThread(2, ref2);
        t2.setPrintStackTrace(false);
        TestUtils.startAll((TestThread[])new TestThread[]{t1, t2});
        TestUtils.sleepMs((long)500L);
        this.barrier.abort();
        t1.join();
        t2.join();
        Assert.assertEquals((long)0L, (long)ref1.get());
        Assert.assertEquals((long)0L, (long)ref2.get());
    }

    public class CommitThread
    extends TestThread {
        private IntRef ref;

        public CommitThread(int id, IntRef ref) {
            super("CommitThread-" + id);
            this.ref = ref;
        }

        @TransactionalMethod
        public void doRun() throws Exception {
            this.ref.inc();
            VetoCommitBarrier_integrationTest.this.barrier.joinCommit(ThreadLocalTransaction.getThreadLocalTransaction());
        }
    }
}

