/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.refs.IntRef;

public class ConcurrentUpdateStressTest {
    private IntRef ref;
    private volatile boolean stop;
    private int threadCount = 3;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.ref = new IntRef(0);
        this.stop = false;
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        TestThread[] threads = this.createThreads();
        long startNs = System.nanoTime();
        TestUtils.startAll((TestThread[])threads);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])threads);
        long count = this.sum((UpdateThread[])threads);
        Assert.assertEquals((long)count, (long)this.ref.get());
        long periodNs = System.nanoTime() - startNs;
        double transactionPerSecond = (double)count * 1.0 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)periodNs;
        System.out.printf("%s Transaction/second\n", TestUtils.format((double)transactionPerSecond));
    }

    public UpdateThread[] createThreads() {
        UpdateThread[] results = new UpdateThread[this.threadCount];
        for (int k = 0; k < this.threadCount; ++k) {
            results[k] = new UpdateThread(k);
        }
        return results;
    }

    private long sum(UpdateThread[] threads) {
        long result = 0L;
        for (UpdateThread t : threads) {
            result += t.count;
        }
        return result;
    }

    public class UpdateThread
    extends TestThread {
        private long count;

        public UpdateThread(int id) {
            super("UpdateThread-" + id);
        }

        public void doRun() {
            while (!ConcurrentUpdateStressTest.this.stop) {
                ConcurrentUpdateStressTest.this.ref.inc();
                if (this.count % 1000000L == 0L) {
                    System.out.printf("%s at %s\n", this.getName(), this.count);
                }
                ++this.count;
            }
        }
    }
}

