/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.financial;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.ThreadLocalTransaction;

public class MoneyTransferStressTest {
    private volatile boolean stop;
    private BankAccount[] accounts;

    @Before
    public void setUp() {
        this.stop = false;
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test_10Accounts_2Threads() {
        this.test(10, 2);
    }

    @Test
    public void test_100Account_10Threads() {
        this.test(100, 10);
    }

    @Test
    public void test_1000Accounts_10Threads() {
        this.test(1000, 10);
    }

    @Test
    public void test_30Accounts_30Threads() {
        this.test(30, 30);
    }

    public void test(int accountCount, int threadCount) {
        this.accounts = new BankAccount[accountCount];
        long initialAmount = 0L;
        for (int k = 0; k < accountCount; ++k) {
            long amount = TestUtils.randomInt((int)1000);
            initialAmount += amount;
            this.accounts[k] = new BankAccount(amount);
        }
        TestThread[] threads = this.createThreads(threadCount);
        TestUtils.startAll((TestThread[])threads);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])threads);
        Assert.assertEquals((long)initialAmount, (long)this.getTotal());
    }

    private long getTotal() {
        long sum = 0L;
        for (BankAccount account : this.accounts) {
            sum += account.getBalance();
        }
        return sum;
    }

    private TransferThread[] createThreads(int threadCount) {
        TransferThread[] threads = new TransferThread[threadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new TransferThread(k);
        }
        return threads;
    }

    private static class NotEnoughMoneyException
    extends RuntimeException {
        static NotEnoughMoneyException INSTANCE = new NotEnoughMoneyException();

        private NotEnoughMoneyException() {
        }
    }

    @TransactionalObject
    private static class BankAccount {
        private long balance;

        private BankAccount(long balance) {
            this.balance = balance;
        }

        @TransactionalMethod(readonly=true)
        public long getBalance() {
            return this.balance;
        }

        public void setBalance(long balance) {
            if (balance < 0L) {
                throw NotEnoughMoneyException.INSTANCE;
            }
            this.balance = balance;
        }

        public void inc(long delta) {
            this.setBalance(this.getBalance() + delta);
        }

        public void dec(long delta) {
            this.setBalance(this.getBalance() - delta);
        }
    }

    private class TransferThread
    extends TestThread {
        public TransferThread(int id) {
            super("TransferThread-" + id);
        }

        public void doRun() throws Exception {
            int k = 0;
            while (!MoneyTransferStressTest.this.stop) {
                try {
                    this.transferBetweenRandomAccounts();
                    if (k % 1000 == 0) {
                        System.out.printf("Thread %s is at iteration %s\n", this.getName(), k);
                    }
                    ++k;
                }
                catch (NotEnoughMoneyException notEnoughMoneyException) {}
            }
        }

        @TransactionalMethod
        private void transferBetweenRandomAccounts() {
            BankAccount from = MoneyTransferStressTest.this.accounts[TestUtils.randomInt((int)MoneyTransferStressTest.this.accounts.length)];
            BankAccount to = MoneyTransferStressTest.this.accounts[TestUtils.randomInt((int)MoneyTransferStressTest.this.accounts.length)];
            int amount = TestUtils.randomInt((int)100);
            to.inc(amount);
            TestUtils.sleepRandomMs((int)20);
            from.dec(amount);
        }
    }
}

