/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.granularity;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.ThreadLocalTransaction;

public class ObjectGranularityTest {
    public AtomicInteger executedCounter;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.executedCounter = new AtomicInteger();
    }

    @Test
    public void testFieldGranularityCausesNoWriteConflicts() {
        Pair pair = new Pair(0, 0);
        SetLeftThread leftThread = new SetLeftThread(pair);
        SetRightThread rightThread = new SetRightThread(pair);
        TestUtils.startAll((TestThread[])new TestThread[]{leftThread, rightThread});
        TestUtils.joinAll((TestThread[])new TestThread[]{leftThread, rightThread});
        Assert.assertEquals((long)10L, (long)pair.getLeft());
        Assert.assertEquals((long)10L, (long)pair.getRight());
        Assert.assertEquals((long)3L, (long)this.executedCounter.get());
    }

    @TransactionalObject
    public static class Pair {
        private int left;
        private int right;

        public Pair(int left, int right) {
            this.left = left;
            this.right = right;
        }

        public int getLeft() {
            return this.left;
        }

        public void setLeft(int left) {
            this.left = left;
        }

        public int getRight() {
            return this.right;
        }

        public void setRight(int right) {
            this.right = right;
        }
    }

    class SetRightThread
    extends TestThread {
        final Pair pair;

        SetRightThread(Pair pair) {
            super("SetRightThread");
            this.pair = pair;
        }

        @TransactionalMethod(readonly=false)
        public void doRun() throws Exception {
            TestUtils.sleepMs((long)500L);
            this.pair.setRight(10);
            TestUtils.sleepMs((long)500L);
            ObjectGranularityTest.this.executedCounter.incrementAndGet();
        }
    }

    class SetLeftThread
    extends TestThread {
        final Pair pair;

        SetLeftThread(Pair pair) {
            super("SetLeftThread");
            this.pair = pair;
        }

        @TransactionalMethod(readonly=false)
        public void doRun() throws Exception {
            TestUtils.sleepMs((long)500L);
            this.pair.setLeft(10);
            TestUtils.sleepMs((long)500L);
            ObjectGranularityTest.this.executedCounter.incrementAndGet();
        }
    }
}

