/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.isolation;

import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.integrationtests.Ref;

public class NoUnwantedReadConsistencyStressTest {
    private volatile boolean stop;
    private int readThreadCount = 10;
    private int refCount = 100;
    private final AtomicLong inconsistenciesCounter = new AtomicLong();
    private Ref[] refs = new Ref[this.refCount];

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.inconsistenciesCounter.set(0L);
        this.stop = false;
    }

    @Test
    public void test() {
        for (int k = 0; k < this.refs.length; ++k) {
            this.refs[k] = new Ref();
        }
        TestThread[] readThreads = new ReadThread[this.readThreadCount];
        for (int k = 0; k < readThreads.length; ++k) {
            readThreads[k] = new ReadThread(k);
        }
        ModifyThread modifyThread = new ModifyThread(0);
        TestUtils.startAll((TestThread[])readThreads);
        TestUtils.startAll((TestThread[])new TestThread[]{modifyThread});
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])readThreads);
        TestUtils.joinAll((TestThread[])new TestThread[]{modifyThread});
        System.out.println("number of readinconsistencies: " + this.inconsistenciesCounter.get());
        Assert.assertTrue((this.inconsistenciesCounter.get() > 0L ? 1 : 0) != 0);
    }

    class ReadThread
    extends TestThread {
        public ReadThread(int id) {
            super("ReadThread-" + id);
        }

        public void doRun() throws Exception {
            int readInconsistencies = 0;
            int k = 0;
            while (!NoUnwantedReadConsistencyStressTest.this.stop) {
                readInconsistencies += this.doread();
                if (k % 10000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ++k;
            }
            NoUnwantedReadConsistencyStressTest.this.inconsistenciesCounter.addAndGet(readInconsistencies);
        }

        private int doread() {
            int[] values = new int[NoUnwantedReadConsistencyStressTest.this.refs.length];
            for (int k = 0; k < NoUnwantedReadConsistencyStressTest.this.refs.length; ++k) {
                values[k] = NoUnwantedReadConsistencyStressTest.this.refs[k].get();
            }
            TestUtils.sleepRandomUs((int)10);
            int inconsistencies = 0;
            for (int k = 0; k < NoUnwantedReadConsistencyStressTest.this.refs.length; ++k) {
                if (values[k] == NoUnwantedReadConsistencyStressTest.this.refs[k].get()) continue;
                ++inconsistencies;
            }
            return inconsistencies;
        }
    }

    class ModifyThread
    extends TestThread {
        public ModifyThread(int id) {
            super("ModifyThread-" + id);
        }

        public void doRun() throws Exception {
            while (!NoUnwantedReadConsistencyStressTest.this.stop) {
                for (Ref ref : NoUnwantedReadConsistencyStressTest.this.refs) {
                    if (!TestUtils.randomOneOf((int)10)) continue;
                    TestUtils.sleepRandomUs((int)10);
                    ref.inc();
                }
            }
        }
    }
}

