/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.isolation;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class PhantomReadStressTest {
    private volatile boolean stop;
    private int readThreadCount = 10;
    private int modifyThreadCount = 2;
    private List table;

    @Before
    public void setUp() {
        this.stop = false;
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void testStrictTransactionalLinkedList() {
        this.test((List)new TransactionalLinkedList(1000000, true));
    }

    @Test
    public void testRelaxedTransactionalLinkedList() {
        this.test((List)new TransactionalLinkedList(1000000, false));
    }

    @Test
    public void testTransactionalArrayList() {
        this.test((List)new TransactionalArrayList());
    }

    public void test(List table) {
        this.table = table;
        TestThread[] modifyThreads = new ModifyThread[this.modifyThreadCount];
        for (int k = 0; k < this.modifyThreadCount; ++k) {
            modifyThreads[k] = new ModifyThread(k);
        }
        TestThread[] readerThread = new ReadThread[this.readThreadCount];
        for (int k = 0; k < this.readThreadCount; ++k) {
            readerThread[k] = new ReadThread(k);
        }
        TestUtils.startAll((TestThread[])modifyThreads);
        TestUtils.startAll((TestThread[])readerThread);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])modifyThreads);
        TestUtils.joinAll((TestThread[])readerThread);
    }

    public class ReadThread
    extends TestThread {
        public ReadThread(int id) {
            super("ReadThread-" + id);
        }

        public void doRun() throws Exception {
            int k = 0;
            while (!PhantomReadStressTest.this.stop) {
                switch (k % 4) {
                    case 0: {
                        this.readWithUpdateTransaction();
                        break;
                    }
                    case 1: {
                        this.readWithReadonlyTransaction();
                        break;
                    }
                    case 2: {
                        this.readWithReadtrackingReadonlyTransaction();
                        break;
                    }
                    case 3: {
                        this.readWithReadtrackingUpdateTransaction();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                ++k;
            }
        }

        @TransactionalMethod(readonly=false, trackReads=false)
        public void readWithUpdateTransaction() {
            this.readLogic();
        }

        @TransactionalMethod(readonly=true, trackReads=false)
        private void readWithReadonlyTransaction() {
            this.readLogic();
        }

        @TransactionalMethod(readonly=false, trackReads=true)
        public void readWithReadtrackingUpdateTransaction() {
            this.readLogic();
        }

        @TransactionalMethod(readonly=true, trackReads=true)
        private void readWithReadtrackingReadonlyTransaction() {
            this.readLogic();
        }

        private void readLogic() {
            int read1 = PhantomReadStressTest.this.table.size();
            TestUtils.sleepRandomMs((int)10);
            int read2 = PhantomReadStressTest.this.table.size();
            Assert.assertEquals((long)read1, (long)read2);
        }
    }

    class ModifyThread
    extends TestThread {
        public ModifyThread(int id) {
            super("ModifyThread-" + id);
        }

        public void doRun() {
            while (!PhantomReadStressTest.this.stop) {
                this.doLogic();
            }
        }

        private void doLogic() {
            PhantomReadStressTest.this.table.add("foo");
            TestUtils.sleepRandomMs((int)10);
            PhantomReadStressTest.this.table.add("foo");
        }
    }
}

