/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.isolation;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.refs.LongRef;

public class ReadConsistencyStressTest {
    private LongRef[] refs;
    private int readerCount = 10;
    private int writerCount = 2;
    private volatile boolean stop;

    @Before
    public void setUp() {
        this.stop = false;
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void testRefCount_2() {
        this.test(2);
    }

    @Test
    public void testRefCount_4() {
        this.test(4);
    }

    @Test
    public void testRefCount_16() {
        this.test(16);
    }

    @Test
    public void testRefCount_64() {
        this.test(64);
    }

    @Test
    public void testRefCount_256() {
        this.test(256);
    }

    @Test
    public void testRefCount_1024() {
        this.test(1024);
    }

    public void test(int refCount) {
        this.refs = new LongRef[refCount];
        for (int k = 0; k < this.refs.length; ++k) {
            this.refs[k] = new LongRef();
        }
        TestThread[] readerThreads = new ReadThread[this.readerCount];
        for (int k = 0; k < readerThreads.length; ++k) {
            readerThreads[k] = new ReadThread(k);
        }
        TestThread[] writerThreads = new WriterThread[this.writerCount];
        for (int k = 0; k < writerThreads.length; ++k) {
            writerThreads[k] = new WriterThread(k);
        }
        TestUtils.startAll((TestThread[])readerThreads);
        TestUtils.startAll((TestThread[])writerThreads);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])readerThreads);
        TestUtils.joinAll((TestThread[])writerThreads);
    }

    public class ReadThread
    extends TestThread {
        public ReadThread(int id) {
            super("ReadThread-" + id);
        }

        public void doRun() throws Exception {
            while (!ReadConsistencyStressTest.this.stop) {
                this.read();
            }
        }

        @TransactionalMethod(readonly=true)
        public void read() {
            long initial = ReadConsistencyStressTest.this.refs[0].get();
            for (int k = 1; k < ReadConsistencyStressTest.this.refs.length; ++k) {
                if (ReadConsistencyStressTest.this.refs[k].get() == initial) continue;
                Assert.fail();
            }
        }
    }

    public class WriterThread
    extends TestThread {
        public WriterThread(int id) {
            super("WriterThread-" + id);
        }

        public void doRun() throws Exception {
            while (!ReadConsistencyStressTest.this.stop) {
                this.write();
                TestUtils.sleepRandomUs((int)100);
            }
        }

        @TransactionalMethod(readonly=false)
        private void write() {
            for (LongRef ref : ReadConsistencyStressTest.this.refs) {
                ref.inc();
            }
        }
    }
}

